/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include "LogTag.h"
using namespace examples;

void LogTag::setToBrowser(const std::string& value)
{
    if (value.empty())
        toBrowser = false;
    else if (value == ("true"))
        toBrowser = true;
    else
        toBrowser = false;
}

int LogTag::doStartTag() throw (JspException)
{
    return EVAL_BODY_TAG;
}

int LogTag::doAfterBody() throw (JspException)
{
    try {
        std::string s = bodyOut->getString();
		std::cerr << s << std::endl;
        if (toBrowser)
            bodyOut->writeOut(bodyOut->getEnclosingWriter());
        return SKIP_BODY;
    } catch (std::exception& ex) {
        throw new JspTagException(ex.what());
    }
}
