/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <string>

#include <sl/java/lang/Object.h>
#include <sl/java/lang/String.h>
#include <sl/java/io/IOException.h>
#include <servlet/jsp_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

#include "ExampleTagBase.h"

namespace examples {

/**
 * Example1: the simplest tag
 * Collect attributes and call into some actions
 *
 * <foo att1="..." att2="...." att3="...." />
 */

class FooTag 
    : public ExampleTagBase 
{
private :
    std::vector<String> atts;
    int i;
    
    void setAtt(int index, String value) {
        atts[index] = value;
    }
    
public :
	FooTag() : i(0) {
	}

	~FooTag() throw() { }

    void setAtt1(String value) {
        setAtt(0, value);
    }
    
    void setAtt2(String value) {
        setAtt(1, value);
    }

    void setAtt3(String value) {
        setAtt(2, value);
    }
    
    /**
     * Process start tag
     *
     * @return EVAL_BODY_INCLUDE
     */
    int doStartTag() throw (JspException) {
        i = 0;
	return EVAL_BODY_TAG;
    }

    void doInitBody() throw (JspException) {
        pageContext->setAttribute("member", Object(new String(atts[i])));
        i++;
    }
    
    int doAfterBody() throw (JspException) {
        try {
            if (i == 3) {
                bodyOut->writeOut(bodyOut->getEnclosingWriter());
                return SKIP_BODY;
            } else
        		pageContext->setAttribute("member",
											Object(new String(atts[i])));
            i++;
            return EVAL_BODY_TAG;
        } catch (IOException ex) {
            throw (JspTagException(ex.what()));
        }
    }
};

} // namespace examples
