/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#ifndef __EXAMPLE_TAG_BASE_H__
#define __EXAMPLE_TAG_BASE_H__

#include <servlet/jsp/JspException.h>
#include <servlet/jsp/tagext/Tag.h>
#include <servlet/jsp/tagext/BodyContent.h>
#include <servlet/jsp/tagext/BodyTagSupport.h>
using namespace servlet::jsp;
using namespace servlet::jsp::tagext;

class ExampleTagBase : public BodyTagSupport {
public :
    void setParent(Tag& parent) {
        this->parent = &parent;
    }

    void setBodyContent(BodyContent& bodyOut) {
        this->bodyOut = &bodyOut;
    }

    void setPageContext(PageContext& pageContext) {
        this->pageContext = &pageContext;
    }

    Tag& getParent() {
        return *this->parent;
    }
    
    int doStartTag() throw (JspException) {
        return SKIP_BODY;
    }

    int doEndTag() throw (JspException) {
        return EVAL_PAGE;
    }
    

    // Default coreations for BodyTag methods as well
    // just in case a tag decides to core BodyTag.
    void doInitBody() throw (JspException) {
    }

    int doAfterBody() throw (JspException) {
        return SKIP_BODY;
    }

    void release() {
        bodyOut = 0;
        pageContext = 0;
        parent = 0;
    }
    
protected :
    BodyContent*	bodyOut;
    PageContext*	pageContext;
    Tag*			parent;
};

#endif // __EXAMPLE_TAG_BASE_H__
