/*
* Copyright 2004 The Apache Software Foundation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#include <string>
#include <vector>
#include <sl/java/lang/String.h>
#include <sl/java/util/Date.h>
#include <sl/java/util/Calendar.h>
using namespace sl::java::lang;
using namespace sl::java::util;

namespace dates {


class JspCalendar {
    Calendar  calendar;

public :
    JspCalendar()
	: calendar(Calendar::getInstance())
    {
        Date trialTime;
        calendar.setTime(trialTime);
    }

    int getYear() {
        return calendar.get(Calendar::YEAR);
    }
    
    String getMonth() {
        int m = getMonthInt();
/*
        String[] months = new String [] { "January", "February", "March",
                                        "April", "May", "June",
                                        "July", "August", "September",
                                        "October", "November", "December" };
*/
	std::vector<String> months;
	months.push_back("January");
	months.push_back("February");
	months.push_back("March");
	months.push_back("April");
	months.push_back("May");
	months.push_back("June");
	months.push_back("July");
	months.push_back("August");
	months.push_back("September");
	months.push_back("October");
	months.push_back("November");
	months.push_back("December");

        if (m > 12)
            return "Unknown to Man";
        
        return months[m - 1];

    }

    String getDay() {
        int x = getDayOfWeek();
/*
        String[] days = new String[] {"Sunday", "Monday", "Tuesday", "Wednesday", 
                                      "Thursday", "Friday", "Saturday"};
*/
		std::vector<String> days;
		days.push_back("Sunday");
		days.push_back("Monday");
		days.push_back("Tuesday");
		days.push_back("Wednesday");
		days.push_back("Thursday");
		days.push_back("Friday");
		days.push_back("Saturday");

        if (x > 7)
            return "Unknown to Man";

        return days[x - 1];

    }
    
    int getMonthInt() {
        return 1 + calendar.get(Calendar::MONTH);
    }

    String getDate() {
        return String() + getMonthInt() + "/" + getDayOfMonth() + "/" +  getYear();

    }

    String getTime() {
        return String() + getHour() + ":" + getMinute() + ":" + getSecond();
    }

    int getDayOfMonth() {
        return calendar.get(Calendar::DAY_OF_MONTH);
    }

    int getDayOfYear() {
        return calendar.get(Calendar::DAY_OF_YEAR);
    }

    int getWeekOfYear() {
        return calendar.get(Calendar::WEEK_OF_YEAR);
    }

    int getWeekOfMonth() {
        return calendar.get(Calendar::WEEK_OF_MONTH);
    }

    int getDayOfWeek() {
        return calendar.get(Calendar::DAY_OF_WEEK);
    }
     
    int getHour() {
        return calendar.get(Calendar::HOUR_OF_DAY);
    }
    
    int getMinute() {
        return calendar.get(Calendar::MINUTE);
    }


    int getSecond() {
        return calendar.get(Calendar::SECOND);
    }

    static void main(String args[]) {
        JspCalendar db;
        p("date: " + db.getDayOfMonth());
        p("year: " + db.getYear());
        p("month: " + db.getMonth());
        p("time: " + db.getTime());
        p("date: " + db.getDate());
        p("Day: " + db.getDay());
        p("DayOfYear: " + db.getDayOfYear());
        p("WeekOfYear: " + db.getWeekOfYear());
        p("era: " + db.getEra());
        p("ampm: " + db.getAMPM());
        p("DST: " + db.getDSTOffset());
        p("ZONE Offset: " + db.getZoneOffset());
        p("TIMEZONE: " + db.getUSTimeZone());
    }

private :
    static void p(String x) {
        //System.out.println(x);
    }


public :
        int getEra() {
        return calendar.get(Calendar::ERA);
    }

    String getUSTimeZone() {
/*
        String[] zones = new String[] {"Hawaii", "Alaskan", "Pacific",
                                       "Mountain", "Central", "Eastern"};
*/
	std::vector<String> zones;
	zones.push_back("Hawaii");
	zones.push_back("Alaskan");
	zones.push_back("Pacific");
	zones.push_back("Mountain");
	zones.push_back("Central");
	zones.push_back("Eastern");
        
        return zones[10 + getZoneOffset()];
    }

    int getZoneOffset() {
        return calendar.get(Calendar::ZONE_OFFSET)/(60*60*1000);
    }


    int getDSTOffset() {
        return calendar.get(Calendar::DST_OFFSET)/(60*60*1000);
    }

    
    int getAMPM() {
        return calendar.get(Calendar::AM_PM);
    }
};

} // namespace dates
