/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: FilterResultServlet.cpp,v 1.11 2007/09/03 15:36:49 cvsuser Exp $
 */

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <sl/object.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace servlet;
using namespace servlet::http;

namespace servlets {

class FilterResultServlet : public HttpServlet {
public :

	void doGet(HttpServletRequest& /* request */, HttpServletResponse& response)
		throw(ServletException)
	{
		response.setContentType("text/html;charset=ISO-8859-1");

		Object o = getServletContext().getAttribute("counter");
		int count = -1;
		try {
			count = sl::object_cast<int>(o);
		} catch (std::bad_cast) {
			throw ServletException("not found counter object");
		}

		PrintWriter out = response.getWriter();
		out.println("<html>");
		out.println("<head>");
		out.println("<title>Filter Result</title>");
		out.println("</head>");
		out.println("<body bgcolor=\"white\">");
		out.println("<center>");
		out.println("<h1>Hello World!</h1>");
		out.println("<hr />\n");
		out.println("Access Counter<br />\n");
		out.println("<table border=\"1\" width=\"100px\"><tr><td align=\"center\">\n");
		out.println(count);
		out.println("</td></tr></table>\n");
		out.println("</center>");
		out.println("</body>");
		out.println("</html>");
	}
};

}

SL_REGIST_LOADABLE_CLASS(servlets::FilterResultServlet)
