/*
 * $Id: FilterExample.cpp,v 1.6 2007/09/03 13:43:13 cvsuser Exp $
 */

#include <iostream>

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/Filter.h>
#include <servlet/FilterChain.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>
using namespace servlet;

namespace filters {

class FilterExample : public Filter {
public :

	void init(FilterConfig& config) throw (ServletException)
	{
		std::cerr << __FILE__ << ":" << __FUNCTION__ << std::endl;
	}

	void destroy() throw()
	{
		std::cerr << __FILE__ << ":" << __FUNCTION__ << std::endl;
	}

	void doFilter(ServletRequest& request, ServletResponse& response,
				  FilterChain& chain)
		throw (ServletException)
	{
		std::cout << __FILE__ << ":" << __FUNCTION__ << " before" << std::endl;
		sl::java::io::PrintWriter out = response.getWriter();
		out.println("BEFORE");

		chain.doFilter(request, response);
		std::cout << __FILE__ << ":" << __FUNCTION__ << " after" << std::endl;
		out.println("AFTER");
	}
};

}

SL_REGIST_LOADABLE_CLASS(filters::FilterExample)
