/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: AccessCountFilter.cpp,v 1.11 2007/09/03 13:43:13 cvsuser Exp $
 */

#include <iostream>

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/Filter.h>
#include <servlet/FilterChain.h>
#include <servlet/FilterConfig.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>
#include <servlet/ServletContext.h>
using namespace sl::java::lang;
using namespace servlet;

namespace filters {

class AccessCountFilter : public Filter {
public :

	void init(FilterConfig& config) throw (ServletException)
	{
		_context = &config.getServletContext();
		_context->setAttribute("counter", Object(int(0)));
	}

	void destroy() throw()
	{ }

	void doFilter(ServletRequest& request, ServletResponse& response,
				  FilterChain& chain)
		throw (ServletException)
	{
		try {
			Object o = _context->getAttribute("counter");
			sl::object_cast<int>(o)++;
		} catch (std::bad_cast&) {
            throw ServletException("fatal error! counter not found.");
        }

		chain.doFilter(request, response);
	}

private :
	ServletContext* _context;
};

}

SL_REGIST_LOADABLE_CLASS(filters::AccessCountFilter)
