/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <fstream>
#include <list>
#include <map>

#include <sl/class_loader.hpp>
#include <sl/java.hpp>
#include <servlet/servlet_headers.h>
using namespace sl::java::lang;
using namespace sl::java::io;
using namespace sl::java::util;
using namespace servlet;
using namespace servlet::http;


namespace servlets {

class SourceViewServlet : public HttpServlet {

    typedef std::map<std::string, std::string> string_map_t;
    string_map_t _color_map_cpp;
    string_map_t _color_map_html;
    string_map_t _replace_map;

public :

    SourceViewServlet()
    {
        _color_map_cpp.insert(std::make_pair("#include",
                            "<font color=\"#0000FF\">#include</font>"));
        _color_map_cpp.insert(std::make_pair("#define",
                            "<font color=\"#0000FF\">#define</font>"));
        _color_map_cpp.insert(std::make_pair("#ifndef",
                            "<font color=\"#0000FF\">#ifndef</font>"));
        _color_map_cpp.insert(std::make_pair("#if",
                            "<font color=\"#0000FF\">#if</font>"));
        _color_map_cpp.insert(std::make_pair("#ifdef",
                            "<font color=\"#0000FF\">#ifdef</font>"));
        _color_map_cpp.insert(std::make_pair("#else",
                            "<font color=\"#0000FF\">#else</font>"));
        _color_map_cpp.insert(std::make_pair("#endif",
                            "<font color=\"#0000FF\">#endif</font>"));

        _color_map_cpp.insert(std::make_pair("class",
                            "<font color=\"#0000FF\">class</font>"));
        _color_map_cpp.insert(std::make_pair("public",
                            "<font color=\"#0000FF\">public</font>"));
        _color_map_cpp.insert(std::make_pair("protected",
                            "<font color=\"#0000FF\">protected</font>"));
        _color_map_cpp.insert(std::make_pair("private",
                            "<font color=\"#0000FF\">private</font>"));
        _color_map_cpp.insert(std::make_pair("throw",
                            "<font color=\"#0000FF\">throw</font>"));
        _color_map_cpp.insert(std::make_pair("using",
                            "<font color=\"#0000FF\">using</font>"));
        _color_map_cpp.insert(std::make_pair("namespace",
                            "<font color=\"#0000FF\">namespace</font>"));

        _color_map_cpp.insert(std::make_pair("SL_REGIST_LOADABLE_CLASS",
                    "<font color=\"#FF0000\">SL_REGIST_LOADABLE_CLASS</font>"));

        _color_map_html.insert(std::make_pair("contentType",
                            "<font color=\"#0000FF\">contentType</font>"));
        _color_map_html.insert(std::make_pair("import",
                            "<font color=\"#0000FF\">import</font>"));
        _color_map_html.insert(std::make_pair("using",
                            "<font color=\"#0000FF\">using</font>"));
        _color_map_html.insert(std::make_pair("namespace",
                            "<font color=\"#0000FF\">namespace</font>"));


        _replace_map.insert(std::make_pair("\"", "&quot;"));
        _replace_map.insert(std::make_pair("<",  "&lt;"));
        _replace_map.insert(std::make_pair(">",  "&gt;"));
        _replace_map.insert(std::make_pair("\t", "    "));
    }

    void doGet(HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException)
    {
        res.setStatus(200);
        res.setContentType("text/html;charset=EUC-JP");

        PrintWriter out = res.getWriter();
        out.println("<html>");
        out.println("<head>");
        out.println("<title>Testing Servlets</title>");
        out.println("</head>");
        out.println("<body bgcolor=\"white\">");

        std::string target = req.getParameter("target");
        std::string data;

        if (target.find("..") != std::string::npos)
            throw ServletException("Target is illegale :" + target);

        if (match_tail(target, ".cpp") ||
            match_tail(target, ".h") || match_tail(target, ".hpp"))
            data = coloringCpp(req, res);
        if (match_tail(target, ".html") || match_tail(target, ".jsp"))
            data = coloringHtml(req, res);
    
        out.println("<h3>Source Code of " + target + "<br></h3>\n");
        out.println("<pre>");
        out.print(data);
        out.println("</pre>");
        out.println("</body>");
        out.println("</html>");
    }

    void doPost(HttpServletRequest& req, HttpServletResponse& res)
        throw(ServletException)
    {
        doGet(req, res);
    }

private :
    bool match_tail(const std::string& s1, const std::string& s2)
    {
        return (s1.find(s2) + s2.length()) == s1.length();
    }

    std::string coloringCpp(HttpServletRequest& req, HttpServletResponse& res)
    {
        std::string file =
                  getServletContext().getRealPath(req.getParameter("target"));

        // եϤ200OK
        std::ifstream ifs(file.c_str());
        if (!ifs)
            throw ServletException("Target file is not found. file is "+file);

        std::string data((std::istreambuf_iterator<char>(ifs)),
                          std::istreambuf_iterator<char>());
        ifs.close();

        std::string::size_type pos;

        string_map_t::iterator i;
        for (i = _replace_map.begin(); i != _replace_map.end(); i++) {
            std::string::size_type prev = 0;
            while ((pos = data.find(i->first, prev)) != std::string::npos) {
                data.replace(pos, i->first.length(), i->second);
                prev = pos + i->second.length();
            }
        }

        for (i = _color_map_cpp.begin(); i != _color_map_cpp.end(); i++) {
            std::string::size_type prev = 0;
            while ((pos = data.find(i->first, prev)) != std::string::npos) {
                size_t len = i->first.length();
                if (data[pos + len] == '('  ||
                    data[pos + len] == ' '  ||
                    data[pos + len] == '\t' ||
                    data[pos + len] == '\r' ||
                    data[pos + len] == '\n')
                    data.replace(pos, i->first.length(), i->second);

                prev = pos + i->second.length();
            }
        }
        
        // '"'  '&quot;' Ѵ.
        std::string::size_type cur = 0;

        bool start = false;
        while ((pos = data.find("&quot;", cur)) != std::string::npos) {
            if (!start) {
                data.replace(pos, 6, "<font color=\"#009900\">&quot;");
                start = true;
                cur = pos + 24;
            } else {
                if (data[pos - 1] == '\\') {
                    cur = pos + 1;
                    continue;
                }
                data.replace(pos + 6, 0, "</font>");
                start = false;
                cur = pos + 8;
            }
        }

        // '/* - */' ΥȤοѤ.
        cur = 0;
        while ((pos = data.find("/*", cur)) != std::string::npos) {
            data.insert(pos, "<font color=\"#909090\">");
            cur = pos + 26;
        }

        cur = 0;
        while ((pos = data.find("*/", cur)) != std::string::npos) {
            data.insert(pos + 2, "</font>");
            cur = pos + 2;
        }

        // '//' ǻϤޤ륳ȤοѤ.
        cur = 0;
        while ((pos = data.find("//", cur)) != std::string::npos) {
            data.insert(pos, "<font color=\"#909090\">");
            cur = pos + 24;

            if ((pos = data.find("\n", cur)) != std::string::npos) {
                data.insert(pos, "</font>");
                cur = pos + 8;
            }
        }
        return data;
    }

    std::string coloringHtml(HttpServletRequest& req, HttpServletResponse& res)
    {
        std::string file =
                  getServletContext().getRealPath(req.getParameter("target"));

        // եϤ200OK
        std::ifstream ifs(file.c_str());
        if (!ifs)
            throw ServletException("Target file is not found. file is "+file);

        std::string data((std::istreambuf_iterator<char>(ifs)),
                          std::istreambuf_iterator<char>());
        ifs.close();

        std::string::size_type pos;

        string_map_t::iterator i;
        for (i = _replace_map.begin(); i != _replace_map.end(); i++) {
            std::string::size_type prev = 0;
            while ((pos = data.find(i->first, prev)) != std::string::npos) {
                data.replace(pos, i->first.length(), i->second);
                prev = pos + i->second.length();
            }
        }

        for (i = _color_map_html.begin(); i != _color_map_html.end(); i++) {
            std::string::size_type prev = 0;
            while ((pos = data.find(i->first, prev)) != std::string::npos) {
                data.replace(pos, i->first.length(), i->second);
                prev = pos + i->second.length();
            }
        }
        
        std::string::size_type cur = 0;

        // '"'  '&quot;' Ѵ.
        bool start = false;
        while ((pos = data.find("&quot;", cur)) != std::string::npos) {
            if (!start) {
                data.replace(pos, 6, "<font color=\"#009900\">&quot;");
                start = true;
                cur = pos + 24;
            } else {
                if (data[pos - 1] == '\\') {
                    cur = pos + 1;
                    continue;
                }
                data.replace(pos + 6, 0, "</font>");
                start = false;
                cur = pos + 8;
            }
        }
#if 0
        // '<! - >' ΥȤοѤ.
        cur = 0;
        while ((pos = data.find("&lt;!", cur)) != std::string::npos) {
            data.insert(pos, "<font color=\"#909090\">");
            cur = pos + 26;
        }

        cur = 0;
        while ((pos = data.find("&gt;", cur)) != std::string::npos) {
            data.insert(pos + 4, "</font>");
            cur = pos + 2;
        }
#endif

        // '<% - %>' ΥȤοѤ.
        cur = 0;
        while ((pos = data.find("&lt;%", cur)) != std::string::npos) {
            data.insert(pos, "<font color=\"#ff6347\">");
            cur = pos + 26;
        }

        cur = 0;
        while ((pos = data.find("%&gt;", cur)) != std::string::npos) {
            data.insert(pos + 5, "</font>");
            cur = pos + 2;
        }

        // '${ - }' ΥȤοѤ.
        start = false;
        for (;;) {
            if (!start && (pos = data.find("${", cur)) != std::string::npos) {
                if (data[pos - 1] == '\\') {
                    cur = pos + 1;
                    continue;
                }
                data.insert(pos, "<font color=\"#ff0000\">");
                start = true;
                cur = pos + 24;
                continue;
            } else
            if (start && (pos = data.find("}", cur)) != std::string::npos) {
                data.insert(pos + 1, "</font>");
                start = false;
                cur = pos + 8;
                continue;
            }
            break;
        }

        return data;
    }
};

}

SL_REGIST_LOADABLE_CLASS(servlets::SourceViewServlet)
