/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "config.h"

#include <unistd.h>
#include <fcntl.h>

#include <cstdlib>    /* daemon() */
#include <iostream>
#include <string>
#include <si/shibainu.h>
#include <si/core/ServerInvoker.h>

extern "C" { extern char **environ; }

void usage()
{
    std::cout << "Usage: shibainu [options]" << std::endl;
    std::cout << "  -f <home>     Set shibainu home directory." << std::endl;
    std::cout << "  -v            shown version." << std::endl;
    std::cout << "  -s            unset signal handler(for debug)." << std::endl;
    std::cout << "  -d            invoke debug mode." << std::endl;
    exit(1);
}


#ifdef __linux__
int daemon(int, int)
{
    pid_t pid = ::fork();
    if (pid < 0) return -1;
    if (pid) ::exit(0);

    if (::setsid() < 0)
        return -1;

    pid = ::fork();
    if (pid < 0) return -1;
    if (pid) ::exit(0);

    ::chdir("/");

    ::close(0);
    ::close(1);
    ::close(2);
    ::open("/dev/null", O_RDWR);
    ::dup(0);
    ::dup(0);
}
#endif // __linux__


/**
 * Ƹ @c main ؿ.
 *
 * Ƹεư˺ɬפʽ¹Ԥ @c ServerInvoker ؽܤޤ.
 *
 * ǽʰ
 * <ol>
 *   <li>-v : ưƸΥСɽޤ.</li>
 *   <li>-f : ưɬפʴĶѿ @c SHIBAINU_HOME ꤷƵưޤ.</li>
 *   <li>-d : ư˥ǡ󲽽Ԥޤ.ǥХåѤǤ.</li>
 * </ol>
 * Ǥ.
 * ǥեȤǤϴĶѿ @c SHIBAINU_HOME ˻ꤵ줿ǥ쥯ȥ
 * ƸΥۡǥ쥯ȥȤƻѤޤ.
 *
 * @param    argc    ưΰο.
 * @param    argv    ưΰ.
 */
int main(int argc, char **argv)
{
//    std::set_unexpected(handler);

    int opt;
    char* home = 0;
        bool debug = false;

    while ((opt = getopt(argc, argv, "df:sv")) != -1) {
        switch (opt) {
                case 'd' :
                        debug = true;
            break;
        case 'v' :
            std::cerr << si::full_version() << std::endl;
            return 0;
        case 'f' :
            home = optarg;
            break;
        default :
            usage();
        }
    }
    argc -= optind;
    argv += optind;

    if (home) {
        ::setenv(si::home().c_str(), home, 1);
    } else if ((home = getenv(si::home().c_str())) == 0) {
        std::cerr << "The environment variable SHIBAINU_HOME is not set.\n"
                  << "Process is stopped.\n" << std::endl;
        return -1;
    }

        if (!debug)
            daemon(0, 0);

    if (::chdir(home) == -1) {
        std::cerr << "Failed change directory :" << home << std::endl;
                return -1;
    }

    si::core::ServerInvoker::run(std::string(home));

    return 0;
}
