/*-
 * Copyright (c) 2008 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SI_WEBXML_SERVLET_H
#define SI_WEBXML_SERVLET_H

#include <string>
#include <si/webxml/basic_map.h>

namespace si {
namespace webxml {

class servlet : public si::webxml::basic_map<std::string, std::string> {
public :
    std::string servlet_name() const
    {
        return _name;
    }

    void servlet_name(const std::string& s)
    {
        _name = s;
    }

    std::string servlet_class() const
    {
        return _class_name;
    }

    void servlet_class(const std::string& s)
    {
        _class_name = s;
    }

    std::string servlet_path() const
    {
        return _path;
    }

    void servlet_path(const std::string& s)
    {
        _path = s;
    }

    std::string load_on_startup() const
    {
        return _startup;
    }

    void load_on_startup(const std::string& s)
    {
        _startup = s;
    }

    void add_init_param(const std::string& s, const std::string& v)
    {
        add(s, v);
    }

    std::string find_init_param(const std::string& s) const
    {
        return find(s);
    }

    void remove_init_param(const std::string& s)
    {
        remove(s);
    }

    std::vector<std::string> init_param_names() const
    {
        return names();
    }

private :
    std::string _name;
    std::string _class_name;
    std::string _path;
    std::string _startup;
};

} // namespace webxml
} // namespace si

#endif // SI_WEBXML_SERVLET_H
