/*-
 * Copyright (c) 2008 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SI_WEBXML_SECURITY_CONSTRAINT_H
#define SI_WEBXML_SECURITY_CONSTRAINT_H

#include <set>
#include <string>
#include <vector>

namespace si {
namespace webxml {

class security_constraint {
public :
    std::string url_pattern() const
    {
        return _url_pattern;
    }

    void url_pattern(const std::string& s)
    {
        _url_pattern = s;
    }

    std::set<std::string> http_method() const
    {
        return _http_method;
    }

    void add_http_method(const std::string& s)
    {
        _http_method.insert(s);
    }

    void remove_http_method(const std::string& s)
    {
        std::set<std::string>::const_iterator i = _http_method.find(s);
        if (i != _http_method.end())
            _http_method.erase(i);
    }

    bool in_http_method(const std::string& s) const
    {
        return _http_method.find(s) != _http_method.end();
    }

    std::set<std::string> role_name() const
    {
        return _role_name;
    }

    void role_name(const std::string& s)
    {
        _role_name.insert(s);
    }

    bool in_role_name(const std::string& s) const
    {
        return _role_name.find(s) != _role_name.end();
    }

private :
    std::string _url_pattern;
    std::set<std::string> _http_method;
    std::set<std::string> _role_name;
};

} // namespace webxml
} // namespace si

#endif // SI_WEBXML_SECURITY_CONSTRAINT_H
