/*-
 * Copyright (c) 2008 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SI_WEBXML_ERROR_PAGE_H
#define SI_WEBXML_ERROR_PAGE_H

#include <string>
#include <si/webxml/basic_map.h>

namespace si {
namespace webxml {

class error_page {
public :
    void add(int n, const std::string& l)
    {
        _cmap.add(n, l);
    }

    void add(const std::string& s, const std::string& l)
    {
        _emap.add(s, l);
    }

    std::string find(int n) const
    {
        return _cmap.find(n);
    }

    std::string find(const std::string& s) const
    {
        return _emap.find(s);
    }

    void remove(int n)
    {
        _cmap.remove(n);
    }

    void remove(const std::string& s)
    {
        _emap.remove(s);
    }

    std::vector<int> error_code() const
    {
        return _cmap.names();
    }

    std::vector<std::string> error_exception() const
    {
        return _emap.names();
    }

private :
    si::webxml::basic_map<int, std::string> _cmap;
    si::webxml::basic_map<std::string, std::string> _emap;
};

} // namespace webxml
} // namespace si

#endif // SI_WEBXML_ERROR_PAGE_H
