/*-
 * Copyright (c) 2008 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SI_WEBXML_BASIC_SET_H
#define SI_WEBXML_BASIC_SET_H

#include <algorithm>
#include <set>

namespace si {
namespace webxml {

template <class ValueType>
class basic_set {
public :
    void add(const ValueType& s)
    {
        _set.insert(s);
    }

    bool find(const ValueType& s) const
    {
        typename std::set<ValueType>::const_iterator i = _set.find(s);
        return i != _set.end() ? true : false;
    }

    void remove(const ValueType& s)
    {
        typename std::set<ValueType>::iterator i = _set.find(s);
        if (i != _set.end())
            _set.erase(i);
    }

    std::set<ValueType> list() const
    {
        return _set;
    }

    std::set<ValueType> get() const
    {
        return _set;
    }

    basic_set<ValueType>& operator+=(const basic_set<ValueType>& r)
    {
        _set.insert(r._set.begin(), r._set.end());
        return *this;
    }

private :
    typename std::set<ValueType> _set;
};

} // namespace webxml
} // namespace si

#endif // SI_WEBXML_BASIC_SET_H
