/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SI_APPLICATION_CONFIG_H
#define SI_APPLICATION_CONFIG_H

#include <sl/xml/xml_tag.h>
#include <si/interface/Config.h>
#include <si/webxml/context_param.h>
#include <si/webxml/error_page.h>
#include <si/webxml/filter.h>
#include <si/webxml/filter_mapping.h>
#include <si/webxml/jsp_config.h>
#include <si/webxml/listener.h>
#include <si/webxml/login_config.h>
#include <si/webxml/mime_mapping.h>
#include <si/webxml/security_constraint.h>
#include <si/webxml/servlet.h>
#include <si/webxml/servlet_mapping.h>
#include <si/webxml/session_config.h>
#include <si/webxml/welcome_file_list.h>

namespace si {
namespace webxml {

class ApplicationConfig {

    typedef std::map<std::string, std::string> string_map_t;
    typedef std::map<std::string, interface::Config> config_map_t;

public :
    /**
     * Constructor/Destructor.
     *
     * @param    xml_path    ƥȤ web.xml եΥѥ.
     */
    ApplicationConfig(const std::string& root, const std::string &xml_path);

    void merge(const ApplicationConfig& target);

    si::webxml::context_param getContextParam() const;

    std::vector<si::webxml::filter> getFilters() const;

    si::webxml::filter_mapping getFilterMapping() const;

    si::webxml::listener getListener() const;

    std::vector<si::webxml::servlet> getServlet() const;

    si::webxml::servlet_mapping getServletMapping() const;

    si::webxml::mime_mapping getMimeMapping() const;

    si::webxml::welcome_file_list getWelcomeFileList() const;

    si::webxml::error_page getErrorPage() const;

    si::webxml::jsp_config getJspConfig() const;

    std::vector<si::webxml::security_constraint> getSecurityConstraint() const;

    si::webxml::login_config getLoginConfig() const;

    si::webxml::session_config getSessionConfig() const;

private :

    /**
     * web-app.context-param.
     *
     * @param    tag    web-app.context-param 
     *            tag_list_t.
     */
    void parse_context_param(const sl::xml::tag_list_t &tag);

    /**
     * web-app.filter
     * web-app.filter۲filter-name filter-class
     * init-param ɤ߹ߡ¸ޤ.
     *    
     * @param    tag    web-app.filter 
     *            tag_list_t󥹥.
     */
    void parse_filter(const sl::xml::tag_list_t &tag);

    /**
     * web-app.filter-mapping.
     *
     * @param    tag    web-app.filter-mapping 
     *            tag_list_t󥹥.
     */
    void parse_filter_mapping(const sl::xml::tag_list_t &tag);

    /**
     * web-app.listener
     * web-app.listener۲listener-classɤ߹ߡ¸ޤ.
     *    
     * @param    tag    web-app.listener 
     *            tag_list_t󥹥.
     */
    void parse_listener(const sl::xml::tag_list_t &tag);

    /**
     * web-app.servlet
     * web-app.servlet۲servlet-name servlet-class
     * init-param ɤ߹ߡ¸ޤ.
     *    
     * @param    tag    web-app.servlet 
     *            tag_list_t󥹥.
     */
    void parse_servlet(const sl::xml::tag_list_t &tag);

    /**
     * web-app.servlet-mapping.
     *
     * @param    tag    web-app.servlet-mapping 
     *            tag_list_t󥹥.
     */
    void parse_servlet_mapping(const sl::xml::tag_list_t &tag);

    /**
     * web-app.mime-mapping.
     *
     * @param    tag    web-app.mime-mapping 
     *            tag_list_t󥹥.
     */
    void parse_mime_mapping(const sl::xml::tag_list_t &tag);

    /**
     * web-app.welcome-file-list.
     * @param    tag    web-app.welcome-file-list  tag_list_t.
     */
    void parse_welcome_file_list(const sl::xml::tag_list_t &tag);

    /**
     * web-app.error_page.
     * @param    tag    web-app.error_page  tag_list_t.
     */
    void parse_error_page(const sl::xml::tag_list_t &tag);

    /**
     * web-app.security-constraint.
     *
     * @param    tag    web-app.security-constraint 
     *            tag_list_t󥹥.
     */
    void parse_security_constraint(const sl::xml::tag_list_t &tag);

    /**
     * web-app.login-config.
     *
     * @param    tag    web-app.login-config 
     *            tag_list_t󥹥.
     */
    void parse_login_config(const sl::xml::tag_list_t &tag);

    /**
     * web-app.jsp-config.
     *
     * @param    tag    web-app.jsp-config 
     *            tag_list_t󥹥.
     */
    void parse_jsp_config(const sl::xml::tag_list_t &tag);

    /**
     * web-app.session-config.
     *
     * @param    tag    web-app.session-config 
     *            tag_list_t󥹥.
     */
    void parse_session_config(const sl::xml::tag_list_t &tag);

    si::webxml::context_param _context_param;
    si::webxml::error_page _error_page;
    std::vector<si::webxml::filter> _filters;
    si::webxml::filter_mapping _filter_mapping;
    si::webxml::jsp_config _jsp_config;
    si::webxml::listener _listener;
    si::webxml::login_config _login_config;
    si::webxml::mime_mapping _mime_mapping;
    std::vector<si::webxml::servlet> _servlets;
    si::webxml::servlet_mapping _servlet_mapping;
    si::webxml::session_config _session_config;
    std::vector<si::webxml::security_constraint> _security_constraint;
    si::webxml::welcome_file_list _welcome_file_list;

    std::string _root;
};

} // namespace webxml
} // namespace si

#endif // SHIBAINU_APPLICATION_CONFIG_H
