/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
#include <string>
#include <vector>
#include <boost/filesystem/convenience.hpp>
#include <boost/filesystem/exception.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/path.hpp>
using namespace std;

#include <sl/java/lang/ClassLoader.h>

#include <si/core/LibraryLoader.h>
using namespace si::core;

LibraryLoader::LibraryLoader()
{ }

LibraryLoader::LibraryLoader(const std::string& path)
{
    load(path);
}


LibraryLoader::~LibraryLoader()
{
    unload();
}

void LibraryLoader::load(const std::string& path)
{
#ifdef DEBUG
    cout << "LibraryLoader::load - " << path << endl;
#endif
    using namespace boost::filesystem;
    try {
    	directory_iterator i(path);
    	directory_iterator end;

    	for (; i != end; ++i) {
    		try {
    			if (is_directory(*i))
    				continue;

    			std::string file = i->string();
    			std::string::size_type pos = file.find(sl::config::dso_suffix);
    			if (pos != std::string::npos) {
    				_loader_list.push_back(file);
    				sl::java::lang::ClassLoader::loadClass(file);
#ifdef DEBUG
    cout << "LibraryLoader::load - loading modules \"" << file << "\"" << endl;
#endif
    			}
    		} catch(runtime_error &e) {
#ifdef DEBUG
    			cerr << "LibraryLoader::load - " << e.what() << endl;
#endif
    		}
    	}

    } catch(boost::filesystem::filesystem_error &e) {
#ifdef DEBUG
    	cerr << "LibraryLoader::load - " << e.what() << endl;
#endif
    }
}

void LibraryLoader::unload()
{
#ifdef DEBUG
    cout << "LibraryLoader::unload - " << endl;
#endif
    std::vector<std::string>::iterator i = _loader_list.begin();
    for (; i != _loader_list.end(); i++)
    	sl::java::lang::ClassLoader::unloadClass(*i);

    _loader_list.clear();
}
