/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
using namespace std;

#include <servlet/ServletContext.h>
#include <servlet/http/HttpSessionBindingEvent.h>
using namespace servlet;

#include <si/core/HttpSessionImpl.h>
using namespace si::core;

//
// Constructor/Destructor
//

HttpSessionImpl::HttpSessionImpl(const string& id)
    : _id(id), _access(false), _available(!id.empty())
{
    _creation_time = ::time(0);
#ifdef DEBUG
    cerr << "HttpSessionImpl:_creation_time:" << _creation_time << endl;
#endif
}


HttpSessionImpl::~HttpSessionImpl()
{ }


bool HttpSessionImpl::operator!() const
{
    return !_available;
}

//
// Member function
//

sl::java::lang::Object HttpSessionImpl::getAttribute(const string& s)
    throw (sl::java::lang::IllegalStateException)
{
    if (!_available)
        throw sl::java::lang::IllegalStateException("getAttribute");

    return Attribute::getAttribute(s);
}

void HttpSessionImpl::setAttribute(const string& s, sl::java::lang::Object o)
    throw (sl::java::lang::IllegalStateException)
{
    if (!_available)
        throw sl::java::lang::IllegalStateException("setAttribute");

    bool exist = Attribute::getAttribute(s) ? true : false;

    Attribute::setAttribute(s, o);

    servlet::http::HttpSessionBindingEvent e(*this, s, o);

    listener_list_t::iterator i = _listener_list.begin();
    for (; i != _listener_list.end(); i++) {
        if (exist)
            (*i)->attributeReplaced(e);
        else
            (*i)->attributeAdded(e);
    }
}

void HttpSessionImpl::removeAttribute(const string& s)
        throw (sl::java::lang::IllegalStateException)
{
    if (!_available)
        throw sl::java::lang::IllegalStateException("removeAttribute");

    sl::java::lang::Object o = Attribute::getAttribute(s);
    Attribute::removeAttribute(s);

    servlet::http::HttpSessionBindingEvent e(*this, s, o);

    listener_list_t::iterator i = _listener_list.begin();
    for (; i != _listener_list.end(); i++)
        (*i)->attributeRemoved(e);
}


sl::java::util::Enumeration HttpSessionImpl::getAttributeNames()
    throw (sl::java::lang::IllegalStateException)
{
    if (!_available)
        throw sl::java::lang::IllegalStateException("getAttributeNames");

    return Attribute::getAttributeNames();
}


long HttpSessionImpl::getCreationTime()
    throw (sl::java::lang::IllegalStateException)
{
    if (!_available)
        throw sl::java::lang::IllegalStateException("getCreateTime");

    return _creation_time;
}


string HttpSessionImpl::getId()
    throw (sl::java::lang::IllegalStateException)
{
    if (!_available)
        throw sl::java::lang::IllegalStateException("getId");

    return _id;
}


long HttpSessionImpl::getLastAccessedTime()
    throw (sl::java::lang::IllegalStateException)
{
    if (!_available)
        throw sl::java::lang::IllegalStateException("getLastAccessedTime");

    return 0;
}


ServletContext &HttpSessionImpl::getServletContext()
{
    return *_context;
}

void HttpSessionImpl::setMaxInactiveInterval(int i)
{
    _session_time = i;
}


int HttpSessionImpl::getMaxInactiveInterval()
{
    return _session_time;
}

void HttpSessionImpl::setAttributeListener(
                            servlet::http::HttpSessionAttributeListener* l)
{
    _listener_list.push_back(l);
}
