/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <servlet/http/Cookie.h>
using namespace servlet::http;

#include <si/core/HttpServletRequestImpl.h>
#include <si/core/HttpServletResponseImpl.h>
using namespace si::core;


HttpServletResponseImpl::HttpServletResponseImpl(
        interface::Connection& connect,
        interface::Context& context)
    : ServletResponseImpl(connect, context), _status(0)
{ }


//
// Member functions
//

void HttpServletResponseImpl::addCookie(const Cookie &c)
{
    _response.addCookie(c);
}

void HttpServletResponseImpl::addDateHeader(const std::string& s, long v)
{
    time_t t = (time_t)v;
    _response.addHeader(s, ctime(&t));
}

void HttpServletResponseImpl::addIntHeader(const std::string& s, int v)
{
    std::string value;
    try {
        value = boost::lexical_cast<std::string>(v);
    } catch (...) {
        return;
    }
    _response.addHeader(s, value);
}

void
HttpServletResponseImpl::addHeader(const std::string& s, const std::string& v)
{
    _response.setHeader(s, v);
}


bool HttpServletResponseImpl::containsHeader(const std::string& s)
{
    return _response.containsHeader(s);
}


std::string HttpServletResponseImpl::encodeRedirectUrl(const std::string& s)
{
    return s;
}


std::string HttpServletResponseImpl::encodeRedirectURL(const std::string& s)
{
    return s;
}


std::string  HttpServletResponseImpl::encodeUrl(const std::string& s)
{
    return s;
}


std::string  HttpServletResponseImpl::encodeURL(const std::string& s)
{
    return s;
}


void HttpServletResponseImpl::sendError(int c)
{
    _response.sendError(c);
}


void HttpServletResponseImpl::sendError(int c, const std::string& s)
{
    _response.sendError(c, s);
    committed();
}


void HttpServletResponseImpl::sendRedirect(const std::string& s)
{
    _response.sendRedirect(s);
    committed();
}


void HttpServletResponseImpl::setDateHeader(const std::string& s, long v)
{
    time_t t = (time_t)v;
    _response.addHeader(s, ctime(&t));
}


void HttpServletResponseImpl::setIntHeader(const std::string& s, int v)
{
    std::string value;
    try {
        value = boost::lexical_cast<std::string>(v);
    } catch (...) {
        return;
    }
    _response.setHeader(s, value);
}


void
HttpServletResponseImpl::setHeader(const std::string& s, const std::string& v)
{
    _response.setHeader(s, v);
}


void HttpServletResponseImpl::setStatus(int c)
{
    _response.setStatus(c);
}


void HttpServletResponseImpl::pairRequest(HttpServletRequestImpl& req)
{
    _pair_request = &req;
}
