/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <vector>
#include <boost/lexical_cast.hpp>
using namespace std;
using namespace boost;

#include <servlet/ServletException.h>
#include <servlet/http/Cookie.h>
#include <servlet/http/HttpSession.h>
using namespace servlet;
using namespace servlet::http;

#include <si/interface/Manager.h>
#include <si/core/HttpServletRequestImpl.h>
#include <si/core/HttpServletResponseImpl.h>
using namespace si::core;


//
// Constructor/Destructor
//

HttpServletRequestImpl::HttpServletRequestImpl(
        interface::Connection& connect,
        interface::Context& context)
: ServletRequestImpl(connect, context),
      _role(false),
      _is_request_session_id_valid(false),
      _is_request_session_id_from_cookie(false),
      _is_request_session_id_from_url(false)
{ }


HttpServletRequestImpl::~HttpServletRequestImpl()
{
}


//
// Member functions.
//

string HttpServletRequestImpl::getAuthType()
{
    return _auth_type;
}


long HttpServletRequestImpl::getDateHeader(const string& s)
    throw(sl::java::lang::IllegalArgumentException)
{
    vector<string> headers = _request.getHeaders(s);

    for (vector<string>::iterator i = headers.begin();
         i != headers.end(); i++)
    {
        try {
            return lexical_cast<long>(*i);
        } catch(bad_lexical_cast &e) {
            throw sl::java::lang::IllegalArgumentException("invalid format");
        }
    }
    return 0;
}


int HttpServletRequestImpl::getIntHeader(const string& s)
    throw(sl::java::lang::NumberFormatException)
{
    vector<string> headers = _request.getHeaders(s);

    for (vector<string>::iterator i = headers.begin();
         i != headers.end(); i++)
    {
        try {
            return lexical_cast<int>(*i);
        } catch(bad_lexical_cast &e) {
            throw sl::java::lang::IllegalArgumentException("invalid format");
        }
    }
    return 0;
}


vector<Cookie> HttpServletRequestImpl::getCookies()
{
    return _request.getCookies();
}


string HttpServletRequestImpl::getHeader(const string& s)
{
    return _request.getHeader(s);
}

vector<string> HttpServletRequestImpl::getHeaders(const string& s)
{
    return _request.getHeaders(s);
}


// å

HttpSession &HttpServletRequestImpl::getSession(bool create)
{
    /*
     * ꥯȤǼJSESSIONIDåƱID
     * å򸡺.
     */
    vector<Cookie> cookies = getCookies();
    copy(_new_cookies.begin(), _new_cookies.end(), back_inserter(cookies));

    vector<Cookie>::const_iterator i = cookies.begin();
    for (; i != cookies.end(); i++) {
        if (i->getName() == "JSESSIONID") {
            HttpSession* s = _context.getManager()->getSession(i->getValue());
            if (s) {
                // å֤ͭ򹹿
                // ߻ȤƤ륻åȤ¸Ƥ
                _context.getManager()->touchSession(i->getValue());
                _referring_sessions.push_back(s);
                return *s;
            }
        }
    }

    HttpSession *s;
    if (create) {
        /*
         * å¸ߤʤ.
         * åȤ _new_cookies  쥹ݥ¦֥Ȥˤ
         * ¸Ƥ
         */
        s = _context.getManager()->createSession(
            _context.getSessionConfig().session_timeout());
        _referring_sessions.push_back(s);

        Cookie c("JSESSIONID", s->getId());
        c.setPath(_context_path);

        _new_cookies.push_back(c);
        _response.addCookie(c);
    } else {
        s = &_null_session;
    }

    return *s;
}


HttpSession &HttpServletRequestImpl::getSession()
{
    return getSession(false);
}


sl::java::util::Enumeration HttpServletRequestImpl::getHeaderNames()
{
    std::vector<std::string> names(_request.getHeaderNames());

    std::vector<sl::java::lang::Object> objs;
    std::vector<std::string>::const_iterator i = names.begin();
    for (; i != names.end(); i++) {
        objs.push_back(sl::java::lang::Object(*i));
    }
    return sl::java::util::Enumeration(objs);
}


string HttpServletRequestImpl::getMethod()
{
    return _request.getMethod();
}


string HttpServletRequestImpl::getPathInfo()
{
    return _path_info;
}


string HttpServletRequestImpl::getPathTranslated()
{
    return _context.getServletContext().getRealPath(getPathInfo());
}


string HttpServletRequestImpl::getContextPath()
{
    return _context_path;
}


string HttpServletRequestImpl::getServletPath()
{
    return _servlet_path;
}


string HttpServletRequestImpl::getQueryString()
{
    return _request.getQueryString();
}


string HttpServletRequestImpl::getRemoteUser()
{
    return _remote_user;
}


sl::java::security::Principal &HttpServletRequestImpl::getUserPrincipal()
{
    return *_principal;
}


bool HttpServletRequestImpl::isUserInRole()
{
    return _role;
}


string HttpServletRequestImpl::getRequestedSessionId()
{
    return _request_session_id;
}


string HttpServletRequestImpl::getRequestUri()
{
    return this->getRequestURI();
}


string HttpServletRequestImpl::getRequestURI()
{
    /*
     * APIǼǽͤ RequestDispatcher::includeRequestDispatcher::forward 
     * ¹ˤäѤ뤿 si::interface::Request ľܻȤʤ.
     *
     * ꥯȼľ DefaultContextValve ǽԤ
     *   RequestDispatcher ѻ RequestDispatcherImpl ǺꤳȤѹ.
     */
    //return _request.getRequestURI();
    if (_context_path == "/")
        return _servlet_path + _path_info;
    return _context_path + _servlet_path + _path_info;
}


string HttpServletRequestImpl::getRequestUrl()
{
    return _request.getRequestURL();
}


string HttpServletRequestImpl::getRequestURL()
{
    return _request.getRequestURL();
}


bool HttpServletRequestImpl::isRequestedSessionIdValid()
{
    return _is_request_session_id_valid;
}


bool HttpServletRequestImpl::isRequestedSessionIdFromCookie()
{
    return _is_request_session_id_from_cookie;
}


bool HttpServletRequestImpl::isRequestedSessionIdFromURL()
{
    return _is_request_session_id_from_url;
}


void HttpServletRequestImpl::setHeader(const string& s, const string& v)
{
    _headers.insert(string_map_t::value_type(s,v));
    _header_names.push_back(string(s));
}


void HttpServletRequestImpl::setMethod(const string& method)
{
    _method = method;
}


void HttpServletRequestImpl::setRequestURI(const string& uri)
{
    _request_uri = uri;
}


void HttpServletRequestImpl::setRequestURL(const string& url)
{
    _request_url = url;
}


void HttpServletRequestImpl::setContextPath(const string& path)
{
    _context_path = path;
}

void HttpServletRequestImpl::setServletPath(const string& path)
{
    _servlet_path = path;
}

void HttpServletRequestImpl::setPathInfo(const string& path)
{
    _path_info = path;
}

void HttpServletRequestImpl::setQueryString(const string& s)
{
    _query_string = s;
}
