/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
#include <string>
#include <boost/regex.hpp>
using namespace std;

#include <si/core/url_pattern.h>
#include <si/core/FilterMapping.h>
using namespace si::core;

FilterMapping::FilterMapping(const string& name)
    : _name(name)
{
}


FilterMapping::~FilterMapping()
{ }


FilterMapping::FilterMapping(const FilterMapping& r)
{
    _servlet_name = r._servlet_name;
    _url_pattern  = r._url_pattern;
    _url_regex    = r._url_regex;
    _dispatcher   = r._dispatcher;
}

void FilterMapping::servletName(const std::string& s)
{
    _servlet_name = s;
}

std::string FilterMapping::servletName() const
{
    return _servlet_name;
}

void FilterMapping::urlPattern(const std::string& s)
{
    _url_pattern = s;
    _url_regex = boost::regex(core::path_to_regex(s));
}

std::string FilterMapping::urlPattern() const
{
    return _url_pattern;
}

void FilterMapping::dispatcher(const std::string& s)
{
    _dispatcher = s;
}

std::string FilterMapping::dispatcher() const
{
    return _dispatcher;
}


bool FilterMapping::match(const string& s) const
{
    return core::pattern_compare()(_url_pattern, s);
}

bool FilterMapping::operator==(const string& s) const
{
    return match(s);
}


bool FilterMapping::operator<(const FilterMapping& r) const
{
    return true;
}
