/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
using namespace std;

#include <si/interface/Context.h>
#include <si/core/FilterConfigImpl.h>
using namespace si::core;

//
// Constructor/Destructor
//

FilterConfigImpl::FilterConfigImpl()
{ }


FilterConfigImpl::~FilterConfigImpl()
{ }


//
// Member functions
//

std::string FilterConfigImpl::getFilterName()
{
    return _name;
}


std::string FilterConfigImpl::getInitParameter(const std::string &s)
{
    string_map_t::iterator i = _parameters.find(s);
    return i != _parameters.end() ? i->second : "";
}


sl::java::util::Enumeration FilterConfigImpl::getInitParameterNames()
{
    std::vector<sl::java::lang::Object> objs; 
    std::set<std::string>::const_iterator i = _para_names.begin();
    for (; i != _para_names.end(); i++) {
        objs.push_back(sl::java::lang::Object(*i));
    }
    return sl::java::util::Enumeration(objs);
}


servlet::ServletContext &FilterConfigImpl::getServletContext()
{
    return *_context;
}

void FilterConfigImpl::setInitParameter(const string_map_t &m)
{
    _parameters = m;

    // ̾ΥꥹȤ
    string_map_t::iterator i = _parameters.begin();
    for (; i != _parameters.end(); i++)
        _para_names.insert(i->first);
}


void FilterConfigImpl::addInitParameter(const string& n, const string& v)
{
    _parameters.insert(std::make_pair(n, v));

    // ̾ΥꥹȤ
    _para_names.insert(n);
}


void FilterConfigImpl::setFilterName(const std::string &s)
{
    _name = s;
}


void FilterConfigImpl::setServletContext(servlet::ServletContext *context)
{
    _context = context;
}
