/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <iostream>
using namespace std;

#include <servlet/http/HttpServletRequest.h>
#include <servlet/http/HttpServletResponse.h>

#include <si/interface/Context.h>
#include <si/core/FilterChainImpl.h>
using namespace si::core;

//
// Constructor/Destructor
//

FilterChainImpl::FilterChainImpl()
{ }


FilterChainImpl::~FilterChainImpl()
{ }


//
// Member functions
//

void FilterChainImpl::doFilter(servlet::ServletRequest &req,
                               servlet::ServletResponse &res)
    throw (servlet::ServletException)
{
    try {
        if (_filters.size()) {
            filter_map_t::iterator i = _filters.begin();
            FilterMapping mapping = i->first;
            filter_ptr    filter  = i->second;
            _filters.erase(i);

            servlet::http::HttpServletRequest& hreq =
                        dynamic_cast<servlet::http::HttpServletRequest&>(req);
            if (!mapping.match(hreq.getRequestURI()))
                return;

            sl::java::lang::Object obj1 = 
                req.getAttribute("javax.servlet.request_dispatcher.forward");
            sl::java::lang::Object obj2 = 
                req.getAttribute("javax.servlet.request_dispatcher.include");

            if (mapping.dispatcher() == "REQUEST" && (obj1 || obj2))
                return;
            if (mapping.dispatcher() == "FORWARD" && !obj1)
                return;
            if (mapping.dispatcher() == "INCLUDE" && !obj2)
                return;

            filter->doFilter(req, res, *this);
        } else {
            servletService(req, res);
        }

    } catch (std::bad_cast& e) {
        cerr << e.what() << endl;
        return;
    }
}


void FilterChainImpl::addFilter(FilterMapping mapping, filter_ptr ptr)
{
    _filters.insert(std::make_pair(mapping, ptr));
}

boost::shared_ptr<servlet::Filter> FilterChainImpl::popFilter()
{
    filter_map_t::iterator i = _filters.begin();
    boost::shared_ptr<servlet::Filter> p = i->second;
    _filters.erase(i);
    return p;
}

void FilterChainImpl::setServlet(servlet::Servlet* p)
{
    _servlet = p;
}

void FilterChainImpl::setWrapper(si::interface::ServletWrapper* p)
{
    _wrapper = p;
}

void FilterChainImpl::servletService(servlet::ServletRequest& req,
                                     servlet::ServletResponse& res)
{
    _wrapper->service(req, res);
}

size_t FilterChainImpl::size() const
{
    return _filters.size();
}
