/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <string>
#include <boost/lexical_cast.hpp>
using namespace std;
using namespace boost;

#include <sl/net/http/http_types.h>
using namespace sl::net::http;

#include <servlet/http/HttpServletRequest.h>
#include <servlet/http/HttpServletResponse.h>
using namespace servlet::http;

#include <si/shibainu.h>
#include <si/core/ErrorPage.h>

//
// Constructor/Destructor
//

ErrorPage::ErrorPage()
{ }


ErrorPage::ErrorPage(int code,
                    const string &uri, const string &type, const string &msg)
{
    create(code, uri, type, msg);
}


//
// Member functions
//

string ErrorPage::result() const
{
    return _string;
}


string ErrorPage::create(int code,
                    const string &uri, const string &type, const string &msg)
{
    _string.append("<html>\n");
    _string.append("<head><title>\n");
    _string.append(si::name() + "/" + si::version() + " - Error report\n");
    _string.append("</title>\n");
    _string.append("<style>\n");
    _string.append("<!--\n");
    _string.append("H1 {font-family:Tahoma,Arial,sans-serif;"
                    "color:white;background-color:peru;"
                    "font-size:22px;}\n");
    _string.append("H2 {font-family:Tahoma,Arial,sans-serif;"
                    "color:white;background-color:peru;"
                    "font-size:16px;}\n");
    _string.append("H3 {font-family:Tahoma,Arial,sans-serif;"
                    "color:white;background-color:peru;"
                    "font-size:14px;}\n");
    _string.append("BODY {font-family:Tahoma,Arial,sans-serif;"
                    "color:peru;background-color:white;}\n");
    _string.append("B {font-family:Tahoma,Arial,sans-serif;"
                    "color:white;background-color:peru;}\n");
    _string.append("P {font-family:Tahoma,Arial,sans-serif;"
                    "background:white;color:peru;font-size:12px;}\n");
    _string.append("A {color : peru;}\n");
    _string.append("A.name {color : peru;}\n");
    _string.append("HR {color : peru;}\n");
    _string.append("-->\n");
    _string.append("</style>\n");
    _string.append("</head>\n");
    _string.append("<body><h1>\n");
    _string.append("HTTP Status \n");
    _string.append(lexical_cast<string>(code));
    _string.append(" - " + uri);
    _string.append("</h1><hr size=\"1\" noshade=\"noshade\">\n");
    _string.append("<p><b>type</b> \n");
    _string.append(type);
    _string.append("</p>\n");
    _string.append("<p><b>message</b> <u>\n");
    _string.append(msg);
    _string.append("</u></p>\n");
    _string.append("<hr size=\"1\" noshade=\"noshade\">\n");
    _string.append("<h3>\n");
    _string.append(si::name() + "/" + si::version() + "\n");
    _string.append("</h3></body></html>");

    return _string;
}
