/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <si/core/EnumerationImpl.h>
using namespace si::core;

#if 0
//
// Constructor/Destructor
//

#if 0
EnumerationImpl::EnumerationImpl (const EnumerationImpl &rhs)
    : _current_pos(0)
{
    _object_list.clear();
    _object_list = rhs._object_list;
}
#endif

EnumerationImpl::~EnumerationImpl()
{
    _object_list.clear();
}


//
// operators.
///
EnumerationImpl &EnumerationImpl::operator=(const EnumerationImpl &rhs)
{
    _object_list.clear();
    _object_list = rhs._object_list;
    _current_pos = 0;
    return *this;
}


sl::java::util::Enumeration &
EnumerationImpl::operator=(const sl::java::util::Enumeration &rhs)
{
    // not catch exception.
    const EnumerationImpl &i = dynamic_cast<const EnumerationImpl &>(rhs);
    *this = i;

    return *this;
}


bool EnumerationImpl::hasMoreElements() const
{
    return _current_pos < _object_list.size();
}


sl::java::lang::Object EnumerationImpl::nextElement()
{
    return _object_list.at(_current_pos++);
} 

EnumerationImpl::operator std::vector<sl::java::lang::Object> ()
{
    return _object_list;
}
#endif
