/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_SERVLET_WRAPPER_H
#define SHIBAINU_INTERFACE_SERVLET_WRAPPER_H

#include <string>
#include <vector>
#include <boost/shared_ptr.hpp>
#include <servlet/Servlet.h>
#include <servlet/ServletContext.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>

#include <si/interface/Base.h>
#include <si/interface/Context.h>
#include <si/interface/Manager.h>
#include <si/interface/Realm.h>

namespace si {
namespace interface {

class Request;
class Response;

class ServletWrapper : virtual public Base {
public :
    virtual ~ServletWrapper() { }

    /**
     * ֥åȤƤ륷ɥ֥Ȥꤷޤ.
     *
     * @param    name    std::string
     */
    virtual void servletClassPath(const std::string& path)=0;

    /**
     * ɥ֥ȤΥѥ֤ޤ.
     *
     * @return        std::string 
     */
    virtual std::string servletClassPath()=0;

    virtual void servletClassName(const std::string& name)=0;

    virtual std::string servletClassName()=0;

    virtual void docBase(const std::string& doc_base)=0;

    virtual std::string docBase()=0;

    virtual void setManager(boost::shared_ptr<Manager> manager)=0;

    virtual boost::shared_ptr<Manager> getManager()=0;

    virtual void addMapping(const std::string& pattern)=0;

    virtual std::vector<std::string> getMapping()=0;

    virtual bool match(const std::string& pattern) const=0;

    virtual void addInitParam(const std::string& n, const std::string& v)=0;

    virtual servlet::ServletContext& getServletContext()=0;

    virtual void setServletContext(servlet::ServletContext&)=0;

    virtual time_t invokeTime()=0;

    virtual void loadInstance()=0;

    virtual void unloadInstance()=0;

    virtual servlet::Servlet *instance()=0;

    virtual void service(Connection* p)=0;

    virtual void service(servlet::ServletRequest&, servlet::ServletResponse&)=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_SERVLET_WRAPPER_H
