/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_SERVICE_H
#define SHIBAINU_INTERFACE_SERVICE_H

#include <set>
#include <string>
#include <vector>
#include <boost/shared_ptr.hpp>

#include <si/interface/Base.h>

namespace si {
namespace interface {

class Connector;
class Engine;
class Loader;
class Logger;

class Service : virtual public Base {
public :
    virtual ~Service() { }

    /**
     * ꥯȤդ Connector 󥹥󥹤Ͽޤ
     * init ؿ¹ˤΤ߸ƽФǽǤꡢ
     * ޤ init ؿ¹ 1 İʾ Connector 󥹥󥹤
     * Ͽɬפޤ
     *
     * @param    connector    Connector  boost::shared_ptr.
     * @throw    ServletException    connector ͭǤʤ.
     *                                initؿ¹ԸθƤӽФ.
     *
     * @see interface::Service::setConnector.
     */
    virtual void addConnector(boost::shared_ptr<Connector> connector)=0;

    /**
     * Service λĥͥ std::set Ȥ֤ޤ.
     * @return Connector  std::set ƥ.
     */
    virtual std::set<boost::shared_ptr<Connector> > getConnectorList()=0;

    /**
     * Engine 󥹥󥹤Ͽޤ
     * init ؿ¹ˤΤ߸ƽФǽǤꡢ
     * ޤ init ؿ¹ 1 İʾ Engine 󥹥󥹤
     * Ͽɬפޤ
     *
     * @param    connector    Connector  boost::shared_ptr.
     *
     * @see interface::Service::setEngine.
     */
    virtual void setEngine(boost::shared_ptr<Engine> engine)=0;

    /**
     * ϿѤߤ Engine 󥹥󥹤֤ޤ
     * @return    Engine ֥.
     */
    virtual boost::shared_ptr<Engine> getEngine() const=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_SERVICE_H
