/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_PIPELINE_H
#define SHIBAINU_INTERFACE_PIPELINE_H

#include <vector>
#include <boost/shared_ptr.hpp>

namespace si {
namespace interface {

class Base;
class Valve;
class ValveContext;
class Connection;

/**
 * @interface.
 *
 * Servlet ƥʤ⥸塼֤̿ϩɽ
 * 󥿡եǤ.
 *
 * ̿ϩ̲᤹ @c inteface::Connection 饹 @c addValve ˤä
 * ꤵƤʣ @c interface::Valve 饹󥹥󥹤ˤä
 * ɾȤߤޤ.
 *
 * Υ饹󥿡եλȤߤ Tomcat 򻲹ͤˤƤꡢ
 * @c Engine  @c Host δ֤ @c Host  @c Context δ֤
 * ʣθڥåե륿󥰵ǽɲä뤿˻Ѥޤ.
 */
class Pipeline {
public :
    /** Destructor. */
    virtual ~Pipeline() { }

    virtual void setBase(Base* base)=0;

    virtual Base* getBase()=0;

    /**
     * @c Pipeline  @c interface::Valve ɲäޤ.
     *
     * @param    valve    @c interface::Valve Ѿ @c Valve
     *                    󥹥󥹤ؤλ.
     */
        virtual void addValve(boost::shared_ptr<Valve>& valve)=0;

    /**
     * @c Pipeline ꤵƤ @c Valve 󥹥󥹤ΥꥹȤ֤ޤ.
     *
     * @return    @c Valve  @c std::vector 󥹥󥹤Υꥹ.
     */
        virtual std::vector<boost::shared_ptr<Valve> > getValve() const=0;

    /**
     * ꤵ줿 @c Valve 󥹥󥹤 @c Pipeline ޤ.
     *  @c Valve 󥹥󥹤¸ߤʤϲ⤪ޤ.
     *
     * @param    valve    @c interface::Valve Ѿ @c Valve
     *                    󥹥󥹤ؤλ.
     */
        virtual void removeValve(boost::shared_ptr<Valve>& valve)=0;

    /**
     * @c Pipeline  @c interface::ValveContext ɲäޤ.
     *
     * @c ValveContext  @c Servlet Ф @c ServletContext Τ褦
     * Servlet ƥʤ䤽¾Υ꥽ @c Valve 󥹥󥹤
     * ٤μʤ󶡤륯饹Ǥ.
     *
     * @param    context        @c interface::ValveContext Ѿ
     *                         @c ValveContext 󥹥󥹤ؤλ.
     */
        virtual void setValveContext(boost::shared_ptr<ValveContext>& valve)=0;

    /**
     * @c Pipeline ꤵƤ @c ValveContext 󥹥󥹤֤ޤ.
     *
     * @return    @c ValveContext 󥹥.
     */
        virtual boost::shared_ptr<ValveContext> getValveContext() const=0;

    /**
     * ³ȶݻƤ @c Valve 󥹥󥹤
     * ɲä줿˵ưޤ.
     *
     * @param    p    饤ȤȤ³ݻ
     *                @c inteface::Connection 󥹥󥹤ؤλ
     */
    virtual void invoke(Connection& connection)=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_PIPELINE_H
