/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_MANAGER_H
#define SHIBAINU_INTERFACE_MANAGER_H

#include <vector>
#include <servlet/http/HttpSession.h>
#include <servlet/http/HttpSessionListener.h>
#include <servlet/http/HttpSessionAttributeListener.h>
#include <servlet/http/HttpSessionActivationListener.h>

#include <si/interface/Base.h>

namespace si {
namespace interface {

/**
 * ꥯȤФ륻å륯饹Ǥ.
 * server.xml  Host/Context ǲ Manager  ˤ
 * ɽ졢ɳĤ Host/Context 饹Υå/ݻޤ.
 */
class Manager : virtual public Base {
public :
    virtual ~Manager() { }

    /**
     * å󥪥֥Ȥޤ.
     * @param    alive    åͭ.
     */
    virtual servlet::http::HttpSession *createSession(int alive)=0;

    /**
     * å󥪥֥Ȥޤ.
     */
    virtual void deleteSession()=0;

    /**
     *  s Υå֤򹹿ޤ.
     * @param    s    å󥪥֥.
     * @return    å̵ͭ.
     *            trues Ф å󤬤
     *            falseå¸ߤƤʤ.
     */
    virtual bool touchSession(servlet::http::HttpSession *s)=0;

    /**
     *  id ĥå֤򹹿ޤ.
     * @param    id    åID.
     * @return    å̵ͭ.
     *            trues Ф å󤬤
     *            falseå¸ߤƤʤ.
     */
    virtual bool touchSession(const std::string& id)=0;

    /**
     * Manager 饹λĥåꥹȤȤ֤ޤ.
     * @return    å vector ꥹ.
     */
    virtual std::vector<servlet::http::HttpSession *> getSessionList()=0;

    /**
     * Manager 饹λĥå֤ޤ.
     * @return    å.
     */
    virtual servlet::http::HttpSession* getSession(const std::string& id)=0;

    /**
     * @c Manager 󥹥󥹤ݻ륻åФ
     * ꥹʡɲäޤ.
     *
     * @param    l    @c HttpSessionListener 󥹥.
     */
    virtual void
    addSessionListener(servlet::http::HttpSessionListener* l)=0;

    /**
     * @c Manager 󥹥󥹤ݻ륻åФ
     * ꥹʡɲäޤ.
     *
     * @param    l    @c HttpSessionAttributeListener 󥹥.
     */
    virtual void
    addSessionAttributeListener(servlet::http::HttpSessionAttributeListener* l)=0;

    /**
     * @c Manager 󥹥󥹤ݻ륻åФ
     * ꥹʡɲäޤ.
     *
     * @param    l    @c HttpSessionActivationListener 󥹥.
     */
    virtual void
    addSessionActivationListener(servlet::http::HttpSessionActivationListener* l)=0;

};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_MANAGER_H
