/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_LOGGER_H
#define SHIBAINU_INTERFACE_LOGGER_H

#include <exception>
#include <string>

namespace si {
namespace interface {

class Config;

/**
 * ƥʤΥϤݲ뤿Υ饹Ǥ.
 * server.xml  Logger ǤȤɽ졢
 * ɸϤեؤΥϤݲκʬ¸ޤ.
 * @note    Logger  Base Υ󥿡եۤȤɬפȤʤ
 *            Base ѾƤʤ.
 */
class Logger {
public :
    enum {
        FATAL_LOG = 0,
        ERROR_LOG = 1,
        WARN_LOG  = 2,
        INFO_LOG  = 3,
        DEBUG_LOG = 4
    };

    /** Destructor. */
    virtual ~Logger() { }

    /**
     * @c Logger Ф빽 @c interface::Config 󥹥󥹤
     * ꤷޤ.
     *
     * @param    conf    Logger ιݻ @c interface::Config
     *                    󥹥󥹤ؤλ.
     */
    virtual void config(const interface::Config& conf)=0;

    /**
     * @c Logger ݻ빽 @c interface::Config
     * 󥹥󥹤֤ޤ.
     *
     * @return        Logger ιݻ @c interface::Config
     *                󥹥󥹤ؤλ.
     */
    virtual interface::Config config()=0;

    /**
     * 򥪡ץ󤷤ޤ.
     * ˤäѤΥץݲ
     * Ŭڤʽޤ.
     *
     * @note    ɸϤؤνϤԤʤ Logger ʤɡ
     *            ץǤϲ⤷ʤ⤢ޤ.
     */
    virtual void open()=0;

    /**
     * 򥯥ޤ.
     * ˤäѤΥݲ
     * Ŭڤʽޤ.
     *
     * @note    ɸϤؤνϤԤʤ Logger ʤɡ
     *            Ǥϲ⤷ʤ⤢ޤ.
     */
    virtual void close()=0;

    /**
     *  msg ˽񤭽Фޤ.
     * @param    msg        ϥ.
     */
    virtual void log(const std::string& msg)=0;

    /**
     *  msg ˽񤭽Фޤ.
     * @param    msg        ϥ.
     * @param    level    ǥХå٥.
     */
    virtual void log(const std::string& msg, int level)=0;

    /**
     *  msg ˽񤭽Фޤ.
     * @param    msg        ϥ.
     * @param    e        㳰饹֥.
     */
    virtual void log(const std::string& msg, const std::exception& e)=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_LOGGER_H
