/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_HOST_H
#define SHIBAINU_INTERFACE_HOST_H

#include <list>
#include <string>
#include <boost/shared_ptr.hpp>

#include <si/interface/Base.h>
#include <si/interface/Pipeline.h>

namespace si {
namespace interface {

class Connection;
class Context;
class Manager;

/**
 * server.xml  Host ǤȤƥФΥۥȤɽ륯饹Ǥ.
 * ʣΥƥ(WEBץꥱ)ݻ/
 * Ȥư뤿ɬפʴؿޤ.
 * ޤۥۥ(VirtualHost)μ¸ Host 饹ˤäƹԤʤޤ.
 */
class Host : virtual public Base, virtual public Pipeline {
public :
    /** Destructor */
    virtual ~Host() { }

    /**
     * ۥȤWEBץꥱ롼ȥǥ쥯ȥꤷޤ.
     *
     * config ؿΰꤵ Config 󥹥󥹤
     * "appBase" ǤꤵƤʤϡinitؿ¹
     * δؿ¹Ԥ "appBase" ꤷʤФʤޤ.
     *
     * @param    name    std::string ۥ̾.
     * @throw    HostException     appBase ʾꤲޤ.
     */
    virtual void appBase(const std::string& app_base)=0;

    /**
     * 󥹥󥹤ꤵ줿ۥȤWEBץꥱ
     * 롼ȥǥ쥯ȥ֤ޤ.
     * @return        std::string ۥȤWEBץꥱ
     *                롼ȥǥ쥯ȥ    .
     */
    virtual std::string appBase()=0;

    /**
     * ۥȤեǼǥ쥯ȥꤷޤ.
     *
     * ǥեȤǤ ${Container.Home}/conf/${Engine.name}/${Host.name}
     * Ǥꡢinit ؿ¹ԸϾ˻ȲǽǤꡢ destroy ؿ
     * ¹ԤޤǤδ֤ѹϹԤʤޤ.
     *
     * @param    name    std::string ۥ̾.
     * @throw    HostException     appBase ʾꤲޤ.
     */
    virtual void setConfDir(const std::string& dir)=0;

    /**
     * 󥹥󥹤ꤵ줿ۥȤեǼǥ쥯ȥ
     * ֤ޤ.
     * init ؿ¹ˤδؿƤӽФ硢ͤȤʤޤ.
     *
     * @return        std::string ۥȤեǼǥ쥯ȥ.
     */
    virtual std::string getConfDir()=0;

    /**
     * ۥȤΥǥ쥯ȥꤷޤ.
     *
     * config ؿΰꤵ Config 󥹥󥹤
     * "workDir" ǤꤵƤʤϡinitؿ¹
     * δؿ¹Ԥ "workDir" ꤷʤФʤޤ.
     *
     * @param    name    std::string ۥ̾.
     * @throw    HostException     appBase ʾꤲޤ.
     */
    virtual void setWorkDir(const std::string& dir)=0;

    /**
     * 󥹥󥹤ꤵ줿ۥȤΥǥ쥯ȥ֤ޤ.
     * @return        std::string ۥȤΥǥ쥯ȥ.
     */
    virtual std::string getWorkDir()=0;

    /**
     * ۥȤФǥեȤΥƥȤꤷޤ.
     *
     * @param    context    interface::Context Υ󥹥.
     */
    virtual void setDefaultContext(boost::shared_ptr<Context> context)=0;

    /**
     * ۥȤФǥեȤΥƥȤ֤ޤ.
     *
     * @return    interface::Context Υ󥹥.
     */
    virtual boost::shared_ptr<Context> getDefaultContext()=0;

    /**
     * ۥȤФ륳ƥȤ(ɲ)ޤ.
     *
     * @param    context    interface::Context Υ󥹥.
     */
    virtual void setContext(boost::shared_ptr<Context>& context)=0;

    /**
     *  path 򥳥ƥȥѥȤƻĥƥȤ֤ޤ.
     *
     * @param    path    std::string ƥȥѥ.
     * @return    interface::Context Υ󥹥.
     */
    virtual boost::shared_ptr<Context> getContext(const std::string& path)=0;

    /**
     * ۥȤλƥȤ֤ޤ.
     *
     * @return    interface::Context  std::set.
     */
    virtual std::vector<boost::shared_ptr<Context> > getContextSet()=0;

    /**
     * ۥȤФ Manager ꤷޤ.
     *
     * @param    manager    interface::Manager Υ󥹥.
     */
    virtual void setManager(boost::shared_ptr<Manager> manager)=0;

    /**
     * ۥȤݻ Manager 󥹥󥹤֤ޤ.
     *
     * @return    interface::Manager Υ󥹥.
     */
    virtual boost::shared_ptr<Manager> getManager()=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_HOST_H
