/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_ENGINE_H
#define SHIBAINU_INTERFACE_ENGINE_H

#include <string>
#include <boost/shared_ptr.hpp>

#include <si/interface/Base.h>
#include <si/interface/Pipeline.h>

namespace si {
namespace interface {

class Connection;
class Host;
class Context;

/**
 * server.xml  Engine Ǥɽ륯饹Ǥ.
 * Service 饹졢Connector 饹 Host 饹
 * Ȥư뤿ɬפʴؿޤ.
 */
class Engine : virtual public Base, virtual public Pipeline {
public :
    /** Destructor */
    virtual ~Engine() { }

    /**
     *  Engine Ф Host Ͽޤ.
     * init ؿ¹ˤΤ߸ƽФǽǤꡢ
     * ޤ init ؿ¹ 1 İʾ Host 󥹥󥹤
     * Ͽɬפޤ.
     *
     * @param    host    Host  boost::shared_ptr.
     * @throw    EngineException        host ͭǤʤ.
     *                                initؿ¹ԸθƤӽФ.
     */
    virtual void setHost(boost::shared_ptr<Host> host)=0;

    /**
     *  name ̾ Host 󥹥󥹤֤ޤ.
     * ¸ߤƤʤ ̵ shared_ptr<Host> ֤ޤ.
     *
     * @param    name    оݤȤʤ Host ̾.
     */
    virtual boost::shared_ptr<Host> getHost(const std::string& name)=0;

    /**
     * ǥեȤǻꤵƤ Host Υ󥹥󥹤֤ޤ.
     * ¸ߤƤʤ ̵ shared_ptr<Host> ֤ޤ.
     *
     */
    virtual boost::shared_ptr<Host> getDefaultHost()=0;

    /**
     *  Engine Ф ǥեȤ Context Ͽޤ.
     * init ؿ¹ˤΤ߸ƽФǽǤ.
     *
     * @param    host    Host  boost::shared_ptr.
     * @throw    EngineException        context ͭǤʤ.
     *                                initؿ¹ԸθƤӽФ.
     */
    virtual void setDefaultContext(boost::shared_ptr<Context> context)=0;

    /**
     *  Engine ФϿ줿ǥեȤ Context ֤ޤ.
     * ϿƤʤ̵ shared_ptr<Context> ֤ޤ.
     * @return    Context 󥹥.
     */
    virtual boost::shared_ptr<Context> getDefaultContext()=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_ENGINE_H
