/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_CONTEXT_H
#define SHIBAINU_INTERFACE_CONTEXT_H

#include <list>
#include <map>
#include <string>
#include <vector>
#include <boost/shared_ptr.hpp>
#include <sl/java/util/EventListener.h>
#include <servlet/ServletContext.h>
#include <servlet/Filter.h>
#include <servlet/FilterChain.h>

#include <si/interface/Base.h>
#include <si/interface/Pipeline.h>
#include <si/webxml/login_config.h>
#include <si/webxml/jsp_config.h>
#include <si/webxml/security_constraint.h>
#include <si/webxml/session_config.h>

namespace si {
namespace interface {

class Connection;
class Host;
class Manager;
class ServletWrapper;

/**
 * ƥȤؤΥ󥿡ե륯饹Ǥ.
 * ƥʥ󥸥󤬥ץꥱ󥳥ƥȤ˥뤿
 * ɬפʴؿޤ.
 * ƤΥץꥱ󥳥ƥȤϤΥ饹
 * ˾ޤ륳ƥȤξ/ѹޤ.
 */
class Context : virtual public Base, virtual public Pipeline {
public :
    /** Destructor */
    virtual ~Context() { }

    /**
     * ƥȤΥѥꤷޤ.
     * @param    path    ƥȥѥ.
     */
    virtual void path(const std::string& path)=0;

    /**
     * ƥȤΥѥ֤ޤ.
     * @return    ƥȥѥ.
     */
    virtual std::string path() const=0;

    /**
     * ɥȥ١ǥ쥯ȥΥѥꤷޤ.
     * @param    docBase    ɥȥ١ǥ쥯ȥѥ.
     */
    virtual void docBase(const std::string& path)=0;

    /**
     * ɥȥ١ǥ쥯ȥΥѥ֤ޤ.
     * @return    ɥȥ١ǥ쥯ȥѥ.
     */
    virtual std::string docBase() const=0;

    /**
     * ƥȤκȥǥ쥯ȥꤷޤ.
     * @param    dir        ȥǥ쥯ȥ.
     */
    virtual void setWorkDir(const std::string& dir)=0;

    /**
     * ƥȤκȥǥ쥯ȥ֤ޤ.
     * @return        ȥǥ쥯ȥ.
     */
    virtual std::string getWorkDir() const=0;

    /**
     *  uri ФơΥƥȤФ URI Ƚꤷޤ.
     * @param    uri    ꥯURI.
     * @return    Ƚ.
     */
    virtual bool match(const std::string& uri) const=0;

    /**
     * ƥȤФ Manager 󥹥󥹤ꤷޤ.
     * @param    Manager 󥹥.
     */
    virtual void setManager(const boost::shared_ptr<Manager>& manager)=0;

    /**
     * ƥȤФ Manager 󥹥󥹤֤ޤ.
     * @return    Manager 󥹥.
     */
    virtual boost::shared_ptr<Manager> getManager() const=0;

    /**
     * ƥȤФ servlet::Filter 󥹥󥹤/ɲäޤ.
     * @param    filter    servlet::Filter 󥹥.
     */
    virtual void addFilter(boost::shared_ptr<servlet::Filter> filter)=0;

    /**
     * ƥ servlet::Filter 󥹥󥹤ΥꥹȤ֤ޤ.
     * @return    servlet::Filter 󥹥.
     */
    virtual std::vector<boost::shared_ptr<servlet::Filter> >
    getFilter() const=0;

    /**
     * ƥȤݻ servlet::FilterChain μΥ󥹥󥹤
     * ֤ޤ.
     * @return    FilterChain 󥹥.
     */
    virtual servlet::FilterChain& getFilterChain()=0;

    /**
     * ƥȤݻ sl::java::util::EventListener μ
     * 󥹥󥹤֤ޤ.
     *
     * @return    sl::java::util::EventListner 󥹥.
     */
        virtual std::vector<boost::shared_ptr<sl::java::util::EventListener> >
        getListeners() const=0;

    /**
     * ƥȤФ ServletWrapper 󥹥󥹤/ɲäޤ.
     * @param    ServletWrapper 󥹥.
     */
    virtual void setWrapper(boost::shared_ptr<ServletWrapper> wrapper)=0;

    /**
     *  path ˥ޥå ServletWrapper 󥹥󥹤֤ޤ.
     * @param    path    uri-patternΥޥåʸ.
     * @return    ServletWrapper 󥹥.
     */
    virtual boost::shared_ptr<ServletWrapper>
    getWrapper(const std::string& path) const=0;

    /**
     *  name ˥ޥå servlet-name  ServletWrapper
                 * 󥹥󥹤֤ޤ.
     * @param    name    оݤ servlet-name.
     * @return    ServletWrapper 󥹥.
     */
    virtual boost::shared_ptr<si::interface::ServletWrapper>
    getNamedWrapper(const std::string& name) const=0;

    /**
     * ƥȤݻ servlet::ServletContext μ
     * 󥹥󥹤֤ޤ.
     * @return    ServletContext 󥹥.
     */
    virtual servlet::ServletContext& getServletContext()=0;

    /**
     * ƥȤư줿֤֤ޤ.
     * @return    ư.
     */
    virtual time_t invokeTime()=0;

    /**
     * web.xml ˵Ҥ줿 security-constraint Ƥ
     * ݻ Config ֤ޤ.
     * @return    Config 󥹥.
     */
    virtual std::vector<si::webxml::security_constraint>
    getSecurityConstraint() const=0;

    /**
     * web.xml ˵Ҥ줿 login-config Ƥ
     * ݻ Config ֤ޤ.
     * @return    Config 󥹥.
     */
    virtual si::webxml::login_config getLoginConfig() const=0;

    /**
     * web.xml ˵Ҥ줿 session-config Ƥ
     * ݻ si::webxml::session_config ֤ޤ.
     * @return    si::webxml::session_config 󥹥.
     */
    virtual si::webxml::session_config getSessionConfig() const=0;

    /**
     * web.xml ˵Ҥ줿 welcome-file ΥꥹȤ֤ޤ.
     */
    virtual std::list<std::string> welcomeFileList() const=0;

    /**
     * addErrorPage ǳǼե֤̾ޤ.
     * @param    code    顼.
     * @return            ե̾.
     */
    virtual std::string getErrorPage(int code) const=0;

    /**
     * addErrorPage ǳǼե֤̾ޤ.
     * @param    e        㳰֥.
     * @return            ե̾.
     */
    virtual std::string getErrorPage(const std::string& e) const=0;

    /**
     * web.xml ˵Ҥ줿 taglib ƤޥåפȤ֤ޤ.
     * @return taglib-uri  taglib-location Υޥå.
     */
    virtual si::webxml::jsp_config getJspConfig() const=0;
};

} // namespace interface
} // namespace si


#endif // SHIBAINU_INTERFACE_CONTEXT_H
