/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_CONNECTION_H
#define SHIBAINU_INTERFACE_CONNECTION_H

#include <string>

namespace si {
namespace interface {

class Request;
class Response;

/**
 * Connector ˤ졢ñΥꥯȤɽޤ.
 *  Connection 󥹥󥹤ʣ Base ͳ
 * ꥯȤޤ.
 */
class Connection {
public :
    /** Destructor. */
    virtual ~Connection() { }

    /**
     * Request 󥹥󥹤֤ޤ.
     * @return    Request 󥹥.
     */
    virtual Request &request()=0;

    /**
     * Response 󥹥󥹤֤ޤ.
     * @return    Response 󥹥.
     */
    virtual Response &response()=0;

    /**
     * ͥǤޤ.
     */
    virtual void close()=0;

    /**
     * ֤ޤ.
     * δؿ Connection 󥹥˼¹Ԥޤ.
     * 
     * @note    HTTP  `KeepAlive :Alive` ǽ¸뤿ˡ
     *            1ꥯȤ close ¹Ԥ٤δؿ
     *            ¹Ԥ졢ɤ߹ߤԤʤ礬ޤ.
     */
    virtual bool init()=0;

    /**
     * ³³Ƥ뤫ǧޤ.
     * @return    bool ³̵ͭ.
     */
    virtual bool available() const=0;

    /**
     * λĥХåե⡢إåϥȥ꡼ؽ񤭽Фޤ.
     * ºݤˤδؿ¹Ԥǽ񤭽ФԤʤ
     * ץȥ˰¸ޤ.
     */
    virtual void flushHeader()=0;

    /**
     * λĥХåե⡢ܥǥϥȥ꡼ؽ񤭽Фޤ.
     * ºݤˤδؿ¹Ԥǽ񤭽ФԤʤ
     * ץȥ˰¸ޤ.
     */
    virtual void flushBody()=0;

    /**
     * λĥХåեϥȥ꡼ؽ񤭽Фޤ.
     * ºݤˤδؿ¹Ԥǽ񤭽ФԤʤ
     * ץȥ˰¸ޤ.
     */
    virtual void flush()=0;

    /**
     * Υۥ̾ޤ.
     * @return    std::string  ۥ̾.
     */
    virtual std::string scheme() const=0;

    /**
     * Υۥ̾ޤ.
     * @return    std::string  ۥ̾.
     */
    virtual std::string localHost() const=0;

    /**
     * IPɥ쥹ޤ.
     * @return    std::string  IPɥ쥹.
     */
    virtual std::string localAddr() const=0;

    /**
     * Υݡֹޤ.
     * @return    int  ѥݡֹ.
     */
    virtual int localPort() const=0;

    /**
     * ⡼ȥۥ̾ޤ.
     * @return    std::string  ۥ̾.
     */
    virtual std::string remoteHost() const=0;

    /**
     * ⡼ȥۥȤIPɥ쥹ޤ.
     * @return    std::string  IPɥ쥹.
     */
    virtual std::string remoteAddr() const=0;

    /**
     * ⡼ȥۥȤΥݡֹޤ.
     * @return    int  ѥݡֹ.
     */
    virtual int remotePort() const=0;

    /**
     * ФΥۥ̾ޤ.
     * @return    std::string  ۥ̾.
     */
    virtual std::string serverHost() const=0;

    /**
     * ФIPɥ쥹ޤ.
     * @return    std::string  IPɥ쥹.
     */
    virtual std::string serverAddr() const=0;

    /**
     * ФΥݡֹޤ.
     * @return    int  ѥݡֹ.
     */
    virtual int serverPort() const=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_CONNECTION_H
