/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_CONFIG_H
#define SHIBAINU_INTERFACE_CONFIG_H

#include <map>
#include <string>
#include <vector>

namespace si {
namespace interface {

/**
 * server.xml  web.xml ξ¸뤿Υ֥ȤǤ.
 *
 * ñ Config 󥹥󥹤XMLΥ°ݻޤ.
 * XMLեΥΤǤʤñ map 
 * ȤƤѤƤޤ.
 *
 * Ǥ XMLݻ륯饹ľܳƥ⥸塼뤬Ȥ
 * ǺѤΤǤμؤäݤ XML ѡ򤤤Ľ񤭴Ƥ
 * ⥸塼ФƶʤƺѤ褦˥åѡȤƻѤޤ.
 */
class Config {
    typedef std::map<std::string, std::string>    string_map_t;

public :
    /** Destructor */
    virtual ~Config() { }

    /**
     *  @c name ̾Ȥ¸ޤ.
     *
     * XMLǻѤϥ̾Ǥꡢޤ
     * ¾ŪǻѤñ˥󥹥󥹤μ̤Ԥʤ
     * Ŭ̾ꤵ줿ꤷޤ.
     *
     * @param    name    ̾ݻ std::string 󥹥.
     */
    void name(const std::string& name)
    {
        _name = name;
    }

    /**
     * ꤵƤ֤̾ޤ.
     *
     * @return    ̾ ݻ std::string 󥹥.
     */
    std::string name() const
    {
        return _name;
    }

    /**
     * ꤵƤǤ̾ΥꥹȤ֤ޤ.
     *
     * @return    @c std::vector<std::string>  ̾ꥹ.
     */
    std::vector<std::string> attr_names() const
    {
        std::vector<std::string> name_list;

        string_map_t::const_iterator i = _attributes.begin();
        for (; i != _attributes.end(); i++)
            name_list.push_back(i->first);
        return name_list;
    }

    /**
     *  name Ȥư value ¸ޤ.
     * Ʊ name ͤ¸ߤƤϾ񤭤ޤ.
     *
     * @param    name    ̾򼨤 @c std::string.
     * @param    value    Ǥͤ򼨤 @c std::string.
     */
    void attr(const std::string& name, const std::string& value)
    {
        _attributes[name] = value;
    }

    /**
     *  name ɳդ֤ͤޤ.
     *
     * @param    @c name ̾.
     * @return    Ǥ.
     */
    std::string attr(const std::string& name) const
    {
        string_map_t::const_iterator i = _attributes.find(name);
        return i != _attributes.end() ? i->second : std::string();
    }

    /**
     * 󥹥󥹤ݻƤ벼̤ @c Config ΥꥹȤ֤ޤ.
     *
     * @return    @c Config ΥꥹȤݻ std::vector.
     */
    std::vector<Config> node_list() const
    {
        return _list;
    }

    /**
     * ̤ @c Config ꥹȤ˻ꤵ줿 @c Config 󥹥󥹤
     * ¸ޤ.
     * 
     * @param    name    ¸оݤ @c Config 󥹥󥹤̾.
     */
    void insert(const Config& c)
    {
        _list.push_back(c);
    }

    /**
     * ̤ @c Config ꥹȤꤵ줿̾ @c Config
     * 󥹥󥹤֤ޤ.
     *
     * @param    name    оݤ @c Config 󥹥󥹤̾.
     * @return     @c Config 󥹥.
     */
    Config get(const std::string& name) const
    {
        return exist(name) ? gets(name).at(0) : Config();
    }

    /**
     * ̤ @c Config ꥹȤꤵ줿̾ @c Config
     * 󥹥󥹤֤ޤ.
     *
     * @param    name    оݤ @c Config 󥹥󥹤̾.
     * @return     @c Config 󥹥󥹤Υꥹ std::vector.
     */
    std::vector<Config> gets(const std::string& name) const
    {
        std::vector<Config> result;

        std::vector<Config>::const_iterator i = _list.begin();
        for (; i != _list.end(); i++) {
            if (i->name() == name)
                result.push_back(*i);
        }
        return result;
    }

    /**
     * ̤ @c Config ꥹȤꤵ줿̾ @c Config
     * 󥹥󥹤ޤ.
     *
     * @param    name    оݤ @c Config 󥹥󥹤̾.
     */
    void erase(const std::string& name)
    {
        std::vector<Config>::iterator i = _list.begin();
        for (; i != _list.end(); i++) {
            if (i->name() == name)
                erase(*i);
        }
    }

    /**
     * ̤ @c Config ꥹȤꤵ줿 @c Config 󥹥󥹤
     * ޤ.
     *
     * @param    name    оݤ @c Config 󥹥󥹤̾.
     */
    void erase(const Config& c)
    {
        //_list.erase(std::remove(_list.begin(), _list.end(), c),
        //            _list.end());
    }

    /**
     * ̤ @c Config ꥹȤꤵ줿̾ @c Config
     * 󥹥󥹤ο֤ޤ.
     *
     * @param    name    оݤ @c Config 󥹥󥹤̾.
     * @return    ¸ߤ @c Config 󥹥󥹤ο.
     */
    bool exist(const std::string& name) const
    {
        return gets(name).size() ? true : false;
    }

    /**
     * ̤ @c Config ꥹȤꤵ줿̾ @c Config
     * 󥹥󥹤ο֤ޤ.
     *
     * @param    name    оݤ @c Config 󥹥󥹤̾.
     * @return    ¸ߤ @c Config 󥹥󥹤ο.
     */
    size_t size(const std::string& name) const
    {
        return gets(name).size();
    }

protected :
    std::string _name;
    string_map_t _attributes;
    std::vector<Config> _list;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_CONFIG_H
