/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_INTERFACE_BASE_H
#define SHIBAINU_INTERFACE_BASE_H

#include <string>
#include <vector>
#include <boost/shared_ptr.hpp>


namespace si {
namespace interface {

class Config;
class Logger;
class Loader;
class Realm;
class Connection;

/**
 * @interface.
 *
 * Servlet ƥʤʤȤʤ륯饹Υ󥿡եޤ.
 * Servlet ƥʤδܵǽ륯饹 @c Base 󥿡ե
 * Ѿɬפޤ.
 * ƤΥ饹 Base 󥿡եѾƤ餺
 *  @c conf/server.xml ˵Ҥ륿Ǥɽ
 * <ol>
 *   <li>@c interface::Server </li>
 *   <li>@c interface::Service </li>
 *   <li>@c interface::Engine </li>
 *   <li>@c interface::Host </li>
 *   <li>@c interface::Context </li>
 *   <li>@c interface::Logger </li>
 *   <li>@c interface::Realm </li>
 *   <li>@c interface::Connector </li>
 * </ol>
 * Ȥʤޤ.
 *
 * ºݤ Base 󥿡եѾɬפΤ
 * Base 󥿡եƱΤ̿ԤʤΤߤǤ.
 */
class Base {
public :
    /** Constructor. */
    virtual ~Base() { }

    /**
     * 줿󥹥󥹤ͭǤ뤫ݤȽꤷޤ.
     *
     * @return    󥹥󥹤¹ԲǽǤ뤫Ƚ̤֤ޤ.
     */
    virtual bool operator!() const=0;

    /**
     * 饹Υե졼ꤷޤ.
     *
     * @param    Config    ե졼ݻ
     *                    interface::Config 󥹥.
     */
    virtual void config(const interface::Config& conf)=0;

    /**
     * 饹Υե졼֤ޤ.
     *
     * @param    ե졼ݻ interface::Config
     *            󥹥.
     */
    virtual interface::Config config() const=0;

    /**
     * 饹Ф̾Τꤷޤ.
     *
     * @param    name    std::string ۥ̾.
     */
    virtual void name(const std::string& name)=0;

    /**
     * 饹Ф̾Τ֤ޤ.
     * 
     * @return    std::string  ̾.
     */
    virtual std::string name() const=0;

    /**
     * 饹̾ꤷޤ.
     *
     * @param    name    std::string 饹̾.
     */
    virtual void className(const std::string &name)=0;

    /**
     * 饹Ф̾Τ֤ޤ.
     * 
     * @return    std::string  ̾.
     */
    virtual std::string className() const=0;

    /**
     * 롼ȥǥ쥯ȥꤷޤ.
     *
     * @param    name    std::string ۥ̾.
     */
    virtual void home(const std::string& home)=0;

    /**
     * 롼ȥǥ쥯ȥ֤ޤ.
     * @return        std::string 롼ȥǥ쥯ȥ.
     */
    virtual std::string home() const=0;

    /**
     * ƤȤʤBase饹󥹥󥹤ꤷޤ.
     *
     * @param    loader    Base  饹Υ󥹥.
     */
    virtual void setParent(Base* parent)=0;

    /**
     * ƤȤʤBase饹󥹥󥹤֤ޤ.
     *
     * @return    Base 饹Υ󥹥
     */
    virtual Base* getParent() const=0;

    /**
     * Υ֥Ȥ饯饹󥹥󥹤ΥɤԤ
     * ǥեȤΥꤷޤ.
     *
     * @param    loader    Loader  饹Υ󥹥.
     */
    virtual void setLoader(const boost::shared_ptr<Loader>& loader)=0;

    /**
     * ꤵƤ륯饹֤ޤ.
     *
     * @return    Loader 饹Υ󥹥
     */
    virtual boost::shared_ptr<Loader> getLoader() const=0;

    /**
     * ϤԤǥեȤΥꤷޤ.
     *
     * @param    logger    Logger  ѥ饹Υ󥹥.
     */
    virtual void setLogger(const boost::shared_ptr<Logger>& logger)=0;

    /**
     * ꤵƤ륯饹֤ޤ.
     *
     * @return    Logger Υ󥹥.
     */
    virtual boost::shared_ptr<Logger> getLogger() const=0;

    /**
     * ꤵ줿 @c config 󥹥󥹤ι @c Logger
     * 󥹥󥹤ޤ.
     *
     * @return    Logger Υ󥹥.
     */
    virtual boost::shared_ptr<Logger>
    loadLogger(const interface::Config& conf)=0;

    /**
     * ϤԤǥեȤΥꤷޤ.
     *
     * @param    logger    Realm  ѥ饹Υ󥹥.
     */
    virtual void setRealm(const boost::shared_ptr<Realm>& realm)=0;

    /**
     * ꤵƤ륯饹֤ޤ.
     *
     * @return    Realm Υ󥹥.
     */
    virtual boost::shared_ptr<Realm> getRealm() const=0;

    /**
     * 饹ɬפʽԤޤ.
     *
     */
    virtual void init()=0;

    /**
     * 饹ɬפʽλԤޤ.
     */
    virtual void destroy()=0;

    /**
     * 饹Υӥ¹Ԥޤ.
     *
     * @param    p    Connection ꥯȥ󥹥.
     */
    virtual void service(Connection* p)=0;
};

} // namespace interface
} // namespace si

#endif // SHIBAINU_INTERFACE_BASE_H
