/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_UTIL_PATH_COMPARATOR_H
#define SHIBAINU_UTIL_PATH_COMPARATOR_H

#include <string>
#include <boost/regex.hpp>

namespace si {
namespace core {

/**
 * servlet-mapping ˻Ѥ url-pattern 򥷥ץɽѹ.
 * @param    pattern        url-patternʸ.
 * @return    ɽѴʸ.
 */
std::string to_regex(const std::string& pattern)
{
    if (pattern.empty())
        return "";

    std::string reg = pattern;
    if (reg[0] == '/')
        reg.insert(0, 1, '^');

    else if (reg[0] == '*') {
        if (reg.length() >= 2 || reg[1] == '.') {
            reg.erase(0, 2);
            reg.insert(0, ".*\\.");
        } else
            reg.insert(0, 1, '.');
    }

    if (reg[reg.length() - 1] != '*')
        reg.append("$");
    return reg;
}

/**
 * ɽˤӤԤʤե󥯥.
 * std::algorithm Ϥ褦 std::binary_function Ѿ.
 */
class path_comparator :
    public std::binary_function<std::string, std::string, bool> {
public :
    path_comparator(const std::string& reg) : _regex(reg) { }

    bool operator()(const std::string& reg, const std::string& url) const
    {
#ifdef DEBUG
std::cerr << "path_comparator::" << __FUNCTION__
          << " reg:[" << reg << "] url:[" << url << "]" << std::endl;
#endif
        if (reg.empty() || url.empty())
            return false;

        try {
            boost::regex r(reg);
            if (boost::regex_search(url, r))
                return true;
        } catch(boost::regex_error &e) {
            std::cerr << e.what() << std::endl;
        }
        return false;
    }
};

} // namespace core
} // namespace si

#endif // SHIBAINU_UTIL_PATH_COMPARATOR_H
