/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_SERVLET_RESPONSE_IMPL_H
#define SHIBAINU_SERVLET_RESPONSE_IMPL_H

#include <sstream>

#include <servlet/ServletException.h>
#include <servlet/ServletResponse.h>

#include <si/interface/Context.h>
#include <si/interface/Connection.h>
#include <si/interface/Logger.h>
#include <si/interface/Request.h>
#include <si/interface/Response.h>
#include <si/core/cbstreambuf.h>
#include <si/core/BasicWriter.h>
#include <si/core/ServletOutputStreamImpl.h>

namespace si {
namespace core {

class ServletResponseImpl : virtual public servlet::ServletResponse {
public :
    /** Interface */
    ServletResponseImpl(interface::Connection& connect,
                        interface::Context& context);

    /** Destructor */
    virtual ~ServletResponseImpl();

    sl::java::io::PrintWriter& getWriter() throw(servlet::ServletException);

    void setContentType(const std::string&);

    servlet::ServletOutputStream& getOutputStream();

    void setContentLength(int i);

    std::string getCharacterEncoding();

    std::string getContentType();

    sl::java::util::Locale getLocale();

    void setLocale(const sl::java::util::Locale& l);

    void setBufferSize(size_t n);

    size_t getBufferSize();

    bool isCommitted();

    void flushBuffer();

    void reset();

    void resetBuffer();
    
    /**
     * PrinteWriterImpl ˤäƸƤ֤Хåեñ
     * Хåؿ.
     */
    void bufferFullHandler(const char* s, size_t n);

    /*
     * ߥåȴλꤹ
     */
    void committed();

protected :
    interface::Response& _response;
    interface::Context& _context;

private :

    core::ocbstream _cbstream;
    BasicWriter* _writer;
    sl::java::io::PrintWriter* _print_writer;
    ServletOutputStreamImpl _output_stream;
    char* _buffer;
    size_t _buffer_size;

    bool _commit_header;
    bool _commit_body;
    int _length;
};

} // namespace core
} // namespace si

#endif    // SHIBAINU_SERVLET_RESPONSE_IMPL_H
