/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SI_CORE_SERVLET_REQUEST_IMPL_H
#define SI_CORE_SERVLET_REQUEST_IMPL_H

#include <iostream>
#include <map>
#include <set>
#include <sstream>
#include <string>

#include <sl/java/lang/Object.h>
#include <sl/java/io/BufferedReader.h>
#include <servlet/RequestDispatcher.h>
#include <servlet/ServletContext.h>
#include <servlet/ServletException.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletRequestAttributeListener.h>

#include <si/interface/Connection.h>
#include <si/interface/Context.h>
#include <si/interface/Request.h>
#include <si/interface/Response.h>
#include <si/core/BasicReader.h>
#include <si/core/EnumerationImpl.h>
#include <si/core/ServletContextImpl.h>
#include <si/core/ServletInputStreamImpl.h>
#include <si/core/Attribute.h>

namespace si {
namespace core {

/**
 * servlet::ServletRequestμ饹Ǥ.
 *
 * ServletRequest饹βۥдؿμȼɬפʥǡ
 * /ѹѤδؿ󶡤ޤ.
 *
 * @note    Υ饹Υ󥹥󥹤ϥꥯ뤿ᡢ
 *             åɤΥåɬ̵ϥ.
 */
class ServletRequestImpl
    : virtual public servlet::ServletRequest, public Attribute {

    typedef std::vector<servlet::ServletRequestAttributeListener*>
                                                        listener_list_t;

public :

    /**
     * Interface.
     * @param    context    ΥꥯȤ륵֥åȤΥƥ.
     */
    ServletRequestImpl(interface::Connection& connect,
                       interface::Context& context);

    /** Destructor. */
    virtual ~ServletRequestImpl();

    sl::java::lang::Object getAttribute(const std::string& s);

    void setAttribute(const std::string& s, sl::java::lang::Object o);

    void removeAttribute(const std::string& s);

    sl::java::util::Enumeration getAttributeNames();

    std::string getParameter(const std::string& s);

    sl::java::util::Enumeration getParameterNames();

    std::vector<std::string> getParameterValues(const std::string& s);

    std::multimap<std::string, std::string> getParameterMap();

    std::auto_ptr<servlet::RequestDispatcher>
    getRequestDispatcher(const std::string& s);

    void setCharacterEncoding(const std::string&);

    std::string getCharacterEncoding();

    int getContentLength();

    std::string getContentType();

    servlet::ServletInputStream& getInputStream();

    sl::java::io::BufferedReader getReader();

    sl::java::util::Locale getLocale();

    sl::java::util::Enumeration getLocales();

    std::string getProtocol();

    std::string getScheme();

    std::string getServerName();

    int getServerPort();

    std::string getLocalAddr();

    std::string getLocalName();

    int getLocalPort();

    std::string getRemoteAddr();

    std::string getRemoteHost();

    int getRemotePort();

    bool isSecure();

    /**
     * ꥯȤ°Фꥹʡꤷޤ.
     *
     * @param    l    °Фꥹʡ
     *                servlet::ServletRequestAttributeListener 󥹥
     *                ؤΥݥ.
     */
    void addAttributeListener(servlet::ServletRequestAttributeListener* l);

    /**
     * °ѹΥꥹʡؤΥ٥Τ̵ͭꤷޤ.
     *
     * ƥ¦ꤹ°ϥꥹʡΤʤͤ뤿
     * ̵ͭڤؤʤȤƻѤ.
     *
     * @param mode true : °ѹꥹʡΤޤ.
     *             false: °ѹꥹʡΤʤ֤ˤޤ.
     */
    void enableAttributeListener(bool mode);

protected :

    /**
     * ꥯȤμ.
     * 饹(HttpServletRequestImpl)⸫褦ˤ.
     */
    interface::Request&  _request;
    interface::Response& _response;
    interface::Context&  _context;

    /**
     * RequestDispatcher μ HttpSession μɬפʤᡢ
     * 饹(HttpServletRequestImpl)⸫褦ˤ.
     */
    servlet::ServletContext& _servlet_context;

private :
    listener_list_t _listener_list;
    bool _notify_listener;

    std::istream&   _input_buffer;
    BasicReader*    _input_reader;
    ServletInputStreamImpl* _input_stream;
};

} // namespace core
} // namespace si

#endif    // SI_CORE_SERVLET_REQUEST_IMPL_H
