/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_SERVLET_CONTEXT_IMPL_H
#define SHIBAINU_SERVLET_CONTEXT_IMPL_H

#include <map>
#include <string>
#include <vector>

#include <sl/java/lang/Object.h>
#include <sl/java/util/Enumeration.h>
#include <servlet/RequestDispatcher.h>
#include <servlet/ServletContext.h>
#include <servlet/ServletContextAttributeListener.h>

#include <si/interface/Context.h>
#include <si/core/Attribute.h>
#include <si/core/EnumerationImpl.h>

namespace si {
namespace core {

class ServletContextImpl
    : virtual public servlet::ServletContext, public Attribute {

    typedef std::map<std::string, std::string> string_map_t;

    typedef std::vector<servlet::ServletContextAttributeListener*>
        listener_list_t;

    static const std::string WEB_INF_CLASSES_DIR;
    static const std::string WEB_INF_LIBRARY_DIR;
    static const std::string WEB_INF_WEB_XML;

public :

    /**
     * Constractor.
     *
     * @param    home        ƥʤΥۡǥ쥯ȥ.
     * @param    base        ƥȤΥ١ǥ쥯ȥ.
     */
    ServletContextImpl(interface::Context* context,
                       const std::string& home, const std::string& base);

    /** Destructor.  */
    ~ServletContextImpl();

    bool operator!();

    sl::java::lang::Object getAttribute(const std::string& s);

    void setAttribute(const std::string& s, sl::java::lang::Object o);

    void removeAttribute(const std::string& s);

    sl::java::util::Enumeration getAttributeNames();

    std::auto_ptr<servlet::RequestDispatcher>
    getRequestDispatcher(const std::string& s);

    std::string getInitParameter(const std::string& s);

    sl::java::util::Enumeration getInitParameterNames();

    servlet::ServletContext &getContext(const std::string& s);

    int    getMajorVersion();

    int getMinorVersion();

    std::string getMimeType(const std::string& s);

    std::auto_ptr<servlet::RequestDispatcher>
    getNamedDispatcher(const std::string& s);

    std::string getRealPath(const std::string& s);

    std::string getResource(const std::string& s);

    std::ifstream& getResourceAsStream(const std::string& s);

    std::set<std::string> getResourcePaths(const std::string& s);

    std::string getServerInfo();

    std::string getServletContextName();

    void log(const std::string&);

    void log(const std::string&, const sl::java::lang::Exception&);

    //--------------------------------------------------------------------//

    /**
     * getServerInfo ؿ֤ͤꤷޤ.
     * @param    params        string 󥹥.
     */
    void setServerInfo(const std::string& s);

    /**
     * getInitParameter ؿ֤ͤꤷޤ.
     * @param    params        string ǹ줿 map 󥹥.
     */
    void addInitParameter(const std::string& s, const std::string& v);

    /**
     * ᥸㡼Сֹꤷޤ.
     * @param    v    Сֹ.
     */
    void setMajorVersion(int v);

    /**
     * ޥʡСֹꤷޤ.
     * @param    v    Сֹ.
     */
    void setMinorVersion(int v);

    /**
     * mime type ޥåפɲäޤ.
     * @param    name    MIME̾.
     * @param    value    MIME̾.
     */
    void addMimeType(const std::string& name, const std::string& value);

    /**
     * ƥʤбƤ Servlet API Υ᥸㡼Сꤷޤ.
     * @param    i    Сֹ.
     */
    void setMajorVersion();

    /**
     * ƥʤбƤ Servlet API ΥޥʡСꤷޤ.
     * @param    i    Сֹ.
     */
    void setMinorVersion();

    /**
     * interface::Context Υ󥹥󥹤֤ޤ.
     * Servlet ¦饳ƥ򻲾Ȥ١ǥХåѤѰդޤ.
     * 
     * @return interaface::Context Υ󥹥.
     */
    interface::Context* getContainerContext();

    /**
     * setAttribute дؿ removeAttribute дؿμ¹Ԥȼ
     * Listener Ф attributeAdded дؿ
     * attributeReplace дؿ attributeRemoved дؿθƤӽФ
     * ServletContextImpl Ԥʤ
     * ServletContextImpl::addAttributeListener 
     * ServletContextAttributeListener ݻ.
     *
     * @param    l    ServletContext °ѹФΤ
     *                servlet::ServletContextAttributeListener ؤΥݥ.
     */
    void addAttributeListener(servlet::ServletContextAttributeListener* l);

private :

    bool _initialized;

    interface::Context* _context;
    string_map_t _mime_mapping;
    string_map_t _parameters;
    std::set<std::string> _para_names;

    std::ifstream* _stream;
    std::string _home;
    std::string _path;
    std::string _doc_base;
    std::string _server_info;
    int _major_version;
    int _minor_version;

    listener_list_t _listener_list;
};


} // namespace core
} // namespace si

#endif // SHIBAINU_SERVLET_CONTEXT_IMPL_H
