/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_SERVLET_CONFIG_IMPL_H
#define SHIBAINU_SERVLET_CONFIG_IMPL_H

#include <map>
#include <stdexcept>
#include <string>
#include <vector>

#include <servlet/ServletConfig.h>
#include <servlet/ServletContext.h>

#include <si/core/EnumerationImpl.h>

namespace si {
namespace core {

class ServletConfigImpl : virtual public servlet::ServletConfig {

    typedef std::map<std::string, std::string> string_map_t;

public :

    ServletConfigImpl();

    /**
     * Constractor.
     * @param    context    ƥƥȥ롼ȥǥ쥯ȥ.
     */
    ServletConfigImpl(servlet::ServletContext* context);

    /** Destoractor. */
    ~ServletConfigImpl();

    /**
     * override ServletConfig function.
     * @see servlet::ServletConfig::getInitParameter.
     */
    std::string getInitParameter(const std::string& s);

    /**
     * override ServletConfig function.
     * @see servlet::ServletConfig::getInitParameterNames.
     */
    sl::java::util::Enumeration getInitParameterNames();

    /**
     * override ServletConfig function.
     * @see servlet::ServletConfig::getServletContext.
     */
    servlet::ServletContext& getServletContext();

    /**
     * override ServletConfig function.
     * @see servlet::ServletConfig::getServletName.
     */
    std::string getServletName();

    /**
     * getInitParameter ǻȤ°ꤷޤ.
     * @param    m        °ꤵ줿 map ֥.
     */
    void setInitParameter(const string_map_t& m);

    /**
     * getServletName ǻȤ륵֥å̾ꤹ.
     * @param    s        string֥å̾.
     */
    void setServletName(const std::string& s);


    void setServletContext(servlet::ServletContext* context);

private :

    servlet::ServletContext* _context;
    string_map_t _parameters;
    std::set<std::string> _para_names;
    std::string _name;
    std::string _class_path;
    std::string _class_name;
    std::string _url_pattern;
    int _session_time;
};

} // namespace core
} // namespace si

#endif // SHIBAINU_SERVLET_CONFIG_IMPL_H
