/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SI_CORE_REQUEST_DISPATCHER_IMPL_H
#define SI_CORE_REQUEST_DISPATCHER_IMPL_H

#include <string>
#include <sl/inet/http_util.hpp>

#include <servlet/RequestDispatcher.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>

#include <si/interface/Context.h>
#include <si/interface/ServletWrapper.h>


namespace si {
namespace core {

/**
 * servlet::RequestDispatcher μ.
 *
 *
 */
class RequestDispatcherImpl : virtual public servlet::RequestDispatcher {
public :
    enum dispatch_mode {
        request_dispatch = 0,
        named_dispatch
    };

    /** Constructor. */
    RequestDispatcherImpl(interface::Context *context);

    /** Destructor. */
    virtual ~RequestDispatcherImpl();

    /**
     *  RequestDispatcher  forward/include ¹Բǽ֤֤ޤ.
     *
     * init ˽Ԥ false ֤֤ˤʤޤ.
     *
     * @return  true : forward/include ¹ԲǽǤ.
     *              false: forward/include ˼¹Բǽʾ֤Ǥ.
     *                   ξ֤ forward/include ¹Ԥ㳰ȯޤ.
     */
    bool operator!() const;

    /**
     * forward μ¹.
     *
     * ưϻͤǤ servlet::RequestDispatcher::forward ˽ޤ.
     *
     */
    void forward(servlet::ServletRequest& req, servlet::ServletResponse& res)
        throw(servlet::ServletException);

    /**
     * include μ¹.
     *
     * ưϻͤǤ servlet::RequestDispatcher::include ˽ޤ.
     *
     */
    void include(servlet::ServletRequest& req, servlet::ServletResponse& res)
        throw(servlet::ServletException);

    /**
     * forward/include Τν.
     *
     *  mode ˤ碌 forward/include νԤޤ.
     * ˽Ԥʤϰʹ operator!()  true ֤ޤ.
     *
     * @param uri forward⤷include ԤURI⤷ϥ֥å̾.
     * @param mode RequestDispatch  NamedDispatch ư.
     */
    void init(const std::string& uri, dispatch_mode mode);

private :
    void initRequestDispatch(const std::string& uri);
    void initNamedDispatch(const std::string& uri);
    void getServletPathAndPathInfo(const std::string& path_string,
                                   si::interface::ServletWrapper* w,
                                   std::string& servlet_path,
                                   std::string& path_info);

    void dispatch(servlet::ServletRequest& req, servlet::ServletResponse& res)
        throw(servlet::ServletException);

    interface::Context*        _context;
    interface::ServletWrapper* _wrapper;
    std::string _uri;
    std::string _servlet_path;
    std::string _path_info;
    std::string _query_string;
    sl::http::parameter_map _parameter;
    dispatch_mode _mode;
    bool _available;
};

} // namespace core
} // namespace si

#endif // SI_CORE_REQUEST_DISPATCHER_IMPL_H
