/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_HTTP_SESSION_IMPL_H
#define SHIBAINU_HTTP_SESSION_IMPL_H

#include <map>
#include <set>
#include <string>
#include <stdexcept>
#include <vector>

#include <servlet/ServletContext.h>
#include <servlet/http/HttpSession.h>
#include <servlet/http/HttpSessionAttributeListener.h>

#include <si/core/Attribute.h>

namespace si {
namespace core {

class HttpSessionImpl
    : virtual public servlet::http::HttpSession, public Attribute
{

    typedef std::map<std::string, std::string> string_map_t;

    typedef std::vector<servlet::http::HttpSessionAttributeListener*>
        listener_list_t;

public :

    /**
     * Constractor.
     * @param    c    ƥʤΥƥ֥.
     * @param    id    ֥åȥƥǰդȤʤʸ.
     * @throw    invalid_argument    ʾꤲޤ.
     */
    HttpSessionImpl(const std::string& id="");

    ~HttpSessionImpl();

    bool operator!() const;

    sl::java::lang::Object getAttribute(const std::string& s)
        throw (sl::java::lang::IllegalStateException);

    void setAttribute(const std::string& s, sl::java::lang::Object o)
        throw (sl::java::lang::IllegalStateException);

    void removeAttribute(const std::string& s)
        throw (sl::java::lang::IllegalStateException);

    sl::java::util::Enumeration getAttributeNames()
        throw (sl::java::lang::IllegalStateException);

    long getCreationTime() throw (sl::java::lang::IllegalStateException);

    std::string getId() throw (sl::java::lang::IllegalStateException);

    long getLastAccessedTime() throw (sl::java::lang::IllegalStateException);

    servlet::ServletContext &getServletContext();

    void setMaxInactiveInterval(int i);

    int getMaxInactiveInterval();

    /**
     * Υå󤬻椫Υե饰ꤷޤ.
     * @param    flag    Ǥ true 󻲾Ǥ false .
     */
    void access(bool flag)
    {
        _access = flag;
    }

    /**
     * ߥ֥åȤˤäƻȤƤ뤫(ѤƤ뤫)οͤ
     * ֤ޤ.
     * @return    Ǥ true 󻲾Ǥ false .
     */
    bool access()
    {
        return _access;
    }

    /**
     * ServletContext ꤷޤ.
     *
     * @param    servlet::ServletContext μ󥹥.
     */
    void setContext(servlet::ServletContext *context)
    {
        _context = context;
    }

    void
    setAttributeListener(servlet::http::HttpSessionAttributeListener* l);

private :

    servlet::ServletContext* _context;
    std::string _id;
    listener_list_t _listener_list;

    string_map_t _parameters;
    std::set<std::string> _para_names;
    long _session_time;
    long _creation_time;
    bool _access;
    bool _available;
};

} // namespace core
} // namespace si

#endif // _MSSSHIBAINU_HTTP_SESSION_IMPL_H
