/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_HTTP_SERVLET_RESPONSE_IMPL_H
#define SHIBAINU_HTTP_SERVLET_RESPONSE_IMPL_H

#include <vector>
#include <map>

#include <servlet/http/Cookie.h>
#include <servlet/http/HttpServletResponse.h>

#include <si/core/ServletResponseImpl.h>

namespace si {
namespace core {

class HttpServletRequestImpl;

class HttpServletResponseImpl
  : public ServletResponseImpl, virtual public servlet::http::HttpServletResponse
{

    typedef std::map<std::string, std::string>    string_map_t;
    typedef std::map<std::string, int>            int_map_t;
    typedef std::map<std::string, long>            long_map_t;

public :

    HttpServletResponseImpl(interface::Connection&,
                            interface::Context&);

    /** Destructor. */
    virtual ~HttpServletResponseImpl() { }

    void addCookie(const servlet::http::Cookie& c);

    void addDateHeader(const std::string& s, long v);

    void addIntHeader(const std::string& s, int v);

    void addHeader(const std::string& s, const std::string& v);

    bool containsHeader(const std::string& s);

    virtual std::string encodeRedirectUrl(const std::string& s);

    virtual std::string encodeRedirectURL(const std::string& s);

    virtual std::string encodeUrl(const std::string& s);

    virtual std::string encodeURL(const std::string& s);

    virtual void sendError(int c);

    virtual void sendError(int c, const std::string& s);

    virtual void sendRedirect(const std::string& s);

    void setDateHeader(const std::string& s, long v);

    void setIntHeader(const std::string& s, int v);

    void setHeader(const std::string& s, const std::string& v);

    void setStatus(int c);

    /**
     * Υ쥹ݥ󥹤ȶ˥֥åȤϤ롢ꥯȥ֥Ȥ
     * ꤷޤ.
     * @param    HttpServletRequestImpl֥.
     */
    void pairRequest(HttpServletRequestImpl& req);

private :

    int _status;
    std::string _msg;
    std::string _redirect_url;
    std::vector<servlet::http::Cookie> _cookies;

    string_map_t _headers;
    int_map_t _int_headers;
    long_map_t _date_headers;

    HttpServletRequestImpl* _pair_request;
};


} // namespace core
} // namespace si

#endif    // SHIBAINU_HTTP_SERVLET_RESPONSE_IMPL_H
