/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_HTTP_SERVLET_REQUEST_IMPL_H
#define SHIBAINU_HTTP_SERVLET_REQUEST_IMPL_H

#include <string>
#include <set>
#include <map>
#include <boost/lexical_cast.hpp>

#include <servlet/ServletContext.h>
#include <servlet/http/Cookie.h>
#include <servlet/http/HttpServletRequest.h>
#include <servlet/http/HttpSession.h>

#include <si/interface/Connection.h>
#include <si/interface/Context.h>
#include <si/interface/Request.h>
#include <si/interface/Response.h>
#include <si/core/ServletRequestImpl.h>
#include <si/core/HttpSessionImpl.h>

namespace si {
namespace core {

class HttpServletResponseImpl;

class HttpServletRequestImpl
    : public ServletRequestImpl,
      virtual public servlet::http::HttpServletRequest
{

    typedef std::map<std::string, std::string> string_map_t;
    typedef std::vector<std::string> string_list_t;    
    typedef std::vector<servlet::http::Cookie> cookie_list_t;
    typedef std::vector<servlet::http::HttpSession *> session_list_t;

public :

    HttpServletRequestImpl(interface::Connection& connect,
                           interface::Context& context);

    virtual ~HttpServletRequestImpl();

    std::string getAuthType();

    std::vector<servlet::http::Cookie> getCookies();

    long getDateHeader(const std::string& s)
        throw (sl::java::lang::IllegalArgumentException);

    int getIntHeader(const std::string& s)
        throw (sl::java::lang::NumberFormatException);

    std::string getHeader(const std::string& s);

    std::vector<std::string> getHeaders(const std::string& s);

    sl::java::util::Enumeration getHeaderNames();

    std::string getMethod();

    std::string getPathInfo();

    std::string getPathTranslated();

    std::string getServletPath();

    std::string getContextPath();

    std::string getQueryString();

    std::string getRemoteUser();

    bool isUserInRole();

    sl::java::security::Principal& getUserPrincipal();

    std::string getRequestedSessionId();

    servlet::http::HttpSession& getSession(bool flag=false);

    servlet::http::HttpSession& getSession();

    std::string getRequestUri();

    std::string getRequestURI();

    std::string getRequestUrl();

    std::string getRequestURL();

    /**
     * ꥯȤ줿åIDͭǤ뤫ɤĴ٤ޤ.
     * @return  bool.
     */
    bool isRequestedSessionIdValid();

    /**
     * ꥯȤ줿åIDCookieȤƤΤĴ٤ޤ.
     * @return  bool.
     */
    bool isRequestedSessionIdFromCookie();

    /**
     * ꥯȤ줿åIDURLȤƤΤĴ٤ޤ.
     * @return  bool.
     */
    bool isRequestedSessionIdFromURL();

    /**
     * ΥꥯȤ˰ n ̾ v ͤĥإåɲäޤ.
     * @param    s    إå̾.
     * @param    v    إå.
     */
    void setHeader(const std::string& s, const std::string& v);

    /**
     * HTTP᥽åɤꤷޤ.
     * @param    method    ᥽å.
     */
    void setMethod(const std::string& method);

    /**
     * RequestURIꤷޤ.
     * @param    uri        ꥯURI.
     */
    void setRequestURI(const std::string& uri);

    /**
     * RequestURLꤷޤ.
     * @param    url        ꥯURL.
     */
    void setRequestURL(const std::string& url);

    /**
     * ContextPatt ֤٤ͤꤷޤ.
     * @param    path    Context Path.
     */
    void setContextPath(const std::string& path);

    /**
     * ServletPath ֤٤ͤꤷޤ.
     * @param    path    Servlet Path.
     */
    void setServletPath(const std::string& path);

    /**
     * getPathInfo ֤٤ͤꤷޤ.
     * @param    path    URIΥѥ.
     */
    void setPathInfo(const std::string& path);

    /**
     * getQueryString ֤٤ͤꤷޤ.
     * @param    url        ꥯURL.
     */
    void setQueryString(const std::string& s);

private :
    string_map_t _headers;
    string_list_t _header_names;
    session_list_t _referring_sessions;
    cookie_list_t _new_cookies;

    std::string _method;
    std::string _request_uri;
    std::string _request_url;
    std::string _context_path;
    std::string _servlet_path;
    std::string _path_info;
    std::string _query_string;
    std::string _auth_type;
    std::string _remote_user;
    std::string _request_session_id;
    bool _role;
    bool _is_request_session_id_valid;
    bool _is_request_session_id_from_cookie;
    bool _is_request_session_id_from_url;
    sl::java::security::Principal* _principal;
    HttpSessionImpl _null_session;
};

} // namespace coree
} // namespace si

#endif    // SHIBAINU_HTTP_SERVLET_REQUEST_IMPL_H
