/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_IMPLEMENT_FILTER_PATTERN_H
#define SHIBAINU_IMPLEMENT_FILTER_PATTERN_H

#include <string>
#include <vector>

#include <boost/regex.hpp>

namespace si {
namespace core {

class FilterMapping {
public :
    FilterMapping(const std::string& name);
    FilterMapping(const FilterMapping& r);
    ~FilterMapping();

    void servletName(const std::string& s);
    void urlPattern(const std::string& s);
    void dispatcher(const std::string& s);
    std::string servletName() const;
    std::string urlPattern() const;
    std::string dispatcher() const;

    bool match(const std::string& s) const;

    bool operator<(const FilterMapping&) const;
    bool operator==(const std::string& s) const;

private :
    std::string _name;
    std::string _servlet_name;
    std::string _url_pattern;
    std::string _dispatcher;
    boost::regex _url_regex;
};

} // namespace core
} // namespace si

#endif // SHIBAINU_IMPLEMENT_FILTER_PATTERN_H
