/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAEKEN_FILTER_CONFIG_IMPL_H
#define SHIBAEKEN_FILTER_CONFIG_IMPL_H

#include <map>
#include <set>
#include <string>

#include <servlet/Filter.h>
#include <servlet/FilterConfig.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>

#include <si/core/EnumerationImpl.h>

namespace si {
namespace core {

class FilterConfigImpl : virtual public servlet::FilterConfig {

    typedef std::map<std::string, std::string> string_map_t;
    typedef std::map<std::string, servlet::Filter*> filter_map_t;

public :
    /** Constructor. */
    FilterConfigImpl();

    /** Destructor. */
    virtual ~FilterConfigImpl();

    std::string getFilterName();

    std::string getInitParameter(const std::string& name);

    sl::java::util::Enumeration getInitParameterNames();

    servlet::ServletContext& getServletContext();

    /**
     * getInitParameter ǻȤ°ꤷޤ.
     * @param    m        °ꤵ줿 map ֥.
     */
    void setInitParameter(const string_map_t &m);

    /**
     * getInitParameter ǻȤ°ꤷޤ.
     * @param    m        °ꤵ줿 map ֥.
     */
    void addInitParameter(const string& n, const std::string& v);

    /**
     * getFilterName ǻȤ륵֥å̾ꤹ.
     * @param    s        stringե륿̾.
     */
    void setFilterName(const std::string &s);

    /**
     * getServletContext ֤륳ƥȥ֥Ȥꤹ.
     * @param    context        ServletContext 󥹥.
     */
    void setServletContext(servlet::ServletContext *context);

private :
    servlet::ServletContext* _context;
    string_map_t _parameters;
    std::set<std::string> _para_names;
    std::string _name;
};

} // namespace core
} // namespace si

#endif // SHIBAEKEN_FILTER_CONFIG_IMPL_H
