/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAEKEN_FILTER_CHAIN_IMPL_H
#define SHIBAEKEN_FILTER_CHAIN_IMPL_H

#include <string>
#include <map>

#include <servlet/Filter.h>
#include <servlet/FilterChain.h>
#include <servlet/Servlet.h>
#include <servlet/ServletRequest.h>
#include <servlet/ServletResponse.h>

#include <si/interface/ServletWrapper.h>
#include <si/core/FilterMapping.h>

namespace si {
namespace core {

class FilterChainImpl : virtual public servlet::FilterChain {

    typedef boost::shared_ptr<servlet::Filter> filter_ptr;
    typedef std::map<FilterMapping, filter_ptr> filter_map_t;

public :
    /** Constructor. */
    FilterChainImpl();

    /** Destructor. */
    virtual ~FilterChainImpl();

    void
    doFilter(servlet::ServletRequest& req, servlet::ServletResponse& res)
        throw(servlet::ServletException);

    /**
     * ե륿ɲä.
     * @param    filter        servlet::FilterѾ󥹥.
     * @param    pattern        FilterPattern ֥. 
     */
    void addFilter(FilterMapping pattern, filter_ptr ptr);

    /**
     * ե륿.
     * @return        servlet::FilterѾ󥹥(shared_ptr<T>).
     */
    filter_ptr popFilter();

    /**
     * ե륿¹Ըư륵֥åȥ󥹥.
     * @param    p    ֥åȥ󥹥󥹤Υݥ.
     */
    void setServlet(servlet::Servlet* p);

    /**
     * ե륿¹Ըư륵֥åȥ󥹥.
     * @param    p    ֥åȥ󥹥󥹤Υݥ.
     */
    void setWrapper(interface::ServletWrapper* p);

    /**
     * ϿƤ Filter ο֤ޤ.
     * @return    Filter .
     */
    size_t size() const;

private :
    /**
     * Servlet::service ؿ¹Ԥޤ.
     */
    void servletService(servlet::ServletRequest& req,
                        servlet::ServletResponse& res);

    interface::ServletWrapper* _wrapper;
    servlet::Servlet* _servlet;
    filter_map_t _filters;
};

} // namespace core
} // namespace si

#endif // SHIBAEKEN_FILTER_CHAIN_IMPL_H
