/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: RequestDumpValve.cpp,v 1.8 2008/05/06 16:26:11 cvsuser Exp $
 */

#include <iostream>
#include <string>
#include <vector>

#include <si/interface/Connection.h>
#include <si/interface/Request.h>
#include <si/interface/ValveContext.h>

#include "RequestDumpValve.h"
using namespace modules::valve;


//
// Constructor/Destructor
//

RequestDumpValve::RequestDumpValve()
{ }

RequestDumpValve::~RequestDumpValve()
{ }

void RequestDumpValve::config(const si::interface::Config& c)
{
	_config = c;
}

si::interface::Config RequestDumpValve::config() const
{
	return _config;
}

void RequestDumpValve::invoke(si::interface::Connection& p,
                              si::interface::ValveContext& context)
{
	si::interface::Request& req = p.request();

	std::clog << " --- The dump of the HTTP data begins --- " << std::endl;
	std::clog << "METHOD :[" << req.getMethod() << "]" << std::endl;
	std::clog << "URL    :[" << req.getRequestURL() << "]" << std::endl;
	std::clog << "URI    :[" << req.getRequestURI() << "]" << std::endl;
	std::clog << "Query  :[" << req.getQueryString() << "]" << std::endl;

	std::vector<std::string> params = req.getParameterNames();
	std::vector<std::string>::iterator i = params.begin();
	for (; i != params.end(); i++)
		std::clog << "Parameter :[" << *i <<"]["<< req.getParameter(*i) << "]" << std::endl;

	std::clog << "Char Encode  :[" << req.getCharacterEncoding() << "]" << std::endl;
	std::clog << "ContentLength:[" << req.getContentLength() << "]" << std::endl;
	std::clog << "ContentType  :[" << req.getContentType() << "]" << std::endl;
	std::clog << "Protocol     :[" << req.getProtocol() << "]" << std::endl;
	std::clog << "Scheme       :[" << req.getScheme() << "]" << std::endl;

	std::vector<std::string> headers = req.getHeaderNames();
	std::vector<std::string>::iterator j = headers.begin();
	for (; j != headers.end(); j++)
		std::clog << "Header :[" << *j << "][" << req.getHeader(*j) << "]" << std::endl;

	std::clog << " --- The dump of the HTTP data is ended ---" << std::endl;

	context.invokeNext(p);
}
