/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SHIBAINU_DIGEST_AUTHENTICATE_VALVE
#define SHIBAINU_DIGEST_AUTHENTICATE_VALVE

#include <string>
#include <sl/class_loader/register.hpp>

#include <si/interface/Valve.h>
#include <si/interface/ValveContext.h>
#include <si/interface/Context.h>
#include <si/interface/Config.h>
#include <si/webxml/security_constraint.h>
using namespace si::interface;

namespace modules {
namespace valve {

class DigestAuthenticateValve : virtual public Valve {
public :
    /** Constructor */
    DigestAuthenticateValve();

    /** Destructor */
    virtual ~DigestAuthenticateValve();

    virtual void config(const si::interface::Config& c);

    virtual si::interface::Config config() const;

    void invoke(Connection& p, ValveContext& context);

private :
    bool service(Connection& connect, Context& context, Logger& logger);
    void sendError401(Connection& connect, const std::string& realm_name);

    si::interface::Config _config;
    si::interface::Context* _context;
    boost::shared_ptr<si::interface::Logger> _logger;

    std::vector<si::webxml::security_constraint> _security_constraints;
    bool _is_authenticates;
};

} // namespace valve
} // namespace modules

SL_REGIST_LOADABLE_CLASS(modules::valve::DigestAuthenticateValve)

#endif // SHIBAINU_DIGEST_AUTHENTICATE_VALVE
