/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef DIR_LIST_H
#define DIR_LIST_H

#include <map>
#include <string>


class DirList {
public :
    static std::string make_list(const std::string& current, const std::multimap<int, std::string>& dirlist)
    {
        std::string result;

        result +=    "<html>"
                    "<head>"
                    "<title>" + current + " Υǥ쥯ȥΰ</title>"
                    "<STYLE>"
                    "<!--"
                    "H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} "
                    "H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} "
                    "H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} "
                    "BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} "
                    "B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} " 
                    "P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;} "
                    "A {color : black;}"
                    "A.name {color : black;}"
                    "HR {color : #525D76;}"
                    "--></STYLE>"
                    "</head>"
                    "<body>"
                    "<h1>/ Υǥ쥯ȥΰ</h1>"
                    "<HR size=\"1\" noshade=\"noshade\">"
                    "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">"
                    "<tr>";

        std::multimap<int, std::string>::const_iterator i = dirlist.begin();
        result += "<tr><td align=\"left\"><font size=\"+1\"><strong>";
        result += "ե̾";
        result += "</strong></font></td>";
        result += "<td align=\"center\"><font size=\"+1\"><strong>";
        result += "";
        result += "</strong></font></td>";
        result += "<td align=\"right\"><font size=\"+1\"><strong>";
        result += "ǽ";
        result += "</strong></font></td></tr>";

        for (; i != dirlist.end(); i++) {
            result += "<tr><td align=\"left\"><strong>";
            result += "<a href=\"";
            result += "/webdav/tomcat-power.gif\"><tt>";
            result += i->second;
            if (i->first)
                result += "/";
            result += "</tt></a></td>";
            result += "</strong></td>";
            result += "<td align=\"center\"><strong>";
            if (!i->first)
                result += "200kb";
            result += "</strong></td>";
            result += "<td align=\"right\"><strong>";
            result += "Fri, 17 Mar 2006 02:26:08 GMT";
            result += "</strong></td></tr>";
        }

        result +=    "</table>"
                    "<HR size=\"1\" noshade=\"noshade\">"
                    "<h3>Apache Tomcat/5.5.12</h3></body>"
                    "</html>";
        return result;
    }
};

#endif // DIR_LIST_H
