/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef MODULES_SERVLETS_DEFAULT_SERVLET_H
#define MODULES_SERVLETS_DEFAULT_SERVLET_H

#include <string>
#include <utility>
#include <vector>
#include <sl/class_loader/register.hpp>

#include <servlet/http/HttpServlet.h>
#include <servlet/http/HttpServletRequest.h>
#include <servlet/http/HttpServletResponse.h>

namespace modules {
namespace servlets {

class DefaultServlet : public servlet::http::HttpServlet {
public :
    DefaultServlet();

    ~DefaultServlet();

    void init() throw(servlet::ServletException);

    void destroy() throw();

    void service(servlet::http::HttpServletRequest& req,
                 servlet::http::HttpServletResponse& res)
        throw(servlet::ServletException);

private :
    void print_directory(const std::string& dir,
                         servlet::http::HttpServletRequest& req,
                         servlet::http::HttpServletResponse& res);

    void print_file(const std::string& file,
                    servlet::http::HttpServletRequest& req,
                    servlet::http::HttpServletResponse& res);

    bool validity_request(servlet::http::HttpServletRequest& req,
                          servlet::http::HttpServletResponse& res);

    bool required_range(servlet::http::HttpServletRequest& req,
                        servlet::http::HttpServletResponse& res,
                        std::vector<std::pair<size_t, size_t> >&,
                        size_t file_size);

    std::string _webapps_path;
    std::string _context_path;
    std::string _context_name;
    servlet::ServletContext* _context;
    int _debug;
    bool _listings;
};

} // namespace servlets
} // namespace modules


SL_REGIST_LOADABLE_CLASS(modules::servlets::DefaultServlet);

#endif // MODULES_SERVLETS_DEFAULT_SERVLET_H
